/*
 * Decompiled with CFR 0.152.
 */
package singularity.text;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import gg.drak.thebase.objects.Identifiable;
import java.time.Duration;
import java.util.Optional;

public class UsersReplacements
implements Identifiable {
    private String identifier;
    private Cache<String, String> replacements;

    public UsersReplacements(String identifier, Cache<String, String> replacements) {
        this.identifier = identifier;
        this.replacements = replacements;
    }

    public UsersReplacements(String identifier) {
        this(identifier, Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(30L)).build());
    }

    public void addReplacement(String key, String value) {
        if (this.hasReplacement(key)) {
            this.removeReplacement(key);
        }
        this.replacements.put(key, value);
    }

    public void removeReplacement(String key) {
        this.replacements.invalidate(key);
    }

    public Optional<String> getReplacement(String key) {
        return Optional.ofNullable(this.replacements.getIfPresent(key));
    }

    public boolean hasReplacement(String key) {
        return this.getReplacement(key).isPresent();
    }

    public String getReplacement(String key, String orElse) {
        return this.getReplacement(key).orElse(orElse);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Cache<String, String> getReplacements() {
        return this.replacements;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setReplacements(Cache<String, String> replacements) {
        this.replacements = replacements;
    }
}

