/*
 * Decompiled with CFR 0.152.
 */
package singularity.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.messages.answered.ReturnableMessage;
import singularity.messages.builders.ProxyParseMessageBuilder;
import singularity.modules.ModuleLike;
import singularity.modules.ModuleUtils;
import singularity.objects.SingleSet;
import singularity.utils.UserUtils;

public class MessageUtils {
    public static Cache<SingleSet<String, String>, String> CACHE = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).build();

    public static void init() {
    }

    public static void logInfo(String message) {
        if (GivenConfigs.getMainConfig().debugConsoleInfoDisabled()) {
            return;
        }
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            Singularity.sendConsoleMessage(GivenConfigs.getMainConfig().debugConsoleInfoPrefix() + line);
        }
    }

    public static void logWarning(String message) {
        if (GivenConfigs.getMainConfig().debugConsoleWarningsDisabled()) {
            return;
        }
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            Singularity.sendConsoleMessage(GivenConfigs.getMainConfig().debugConsoleWarningsPrefix() + line);
        }
    }

    public static void logSevere(String message) {
        if (GivenConfigs.getMainConfig().debugConsoleErrorsDisabled()) {
            return;
        }
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            Singularity.sendConsoleMessage(GivenConfigs.getMainConfig().debugConsoleErrorsPrefix() + line);
        }
    }

    public static void logDebug(String message) {
        if (GivenConfigs.getMainConfig().debugConsoleDebugDisabled()) {
            return;
        }
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            Singularity.sendConsoleMessage(GivenConfigs.getMainConfig().debugConsoleDebugPrefix() + line);
        }
    }

    public static void logInfo(StackTraceElement[] stackTraceElements) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logInfo(stackTraceElement.toString()));
    }

    public static void logWarning(StackTraceElement[] stackTraceElements) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logWarning(stackTraceElement.toString()));
    }

    public static void logSevere(StackTraceElement[] stackTraceElements) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logSevere(stackTraceElement.toString()));
    }

    public static void logDebug(StackTraceElement[] stackTraceElements) {
        Arrays.stream(stackTraceElements).forEach(stackTraceElement -> MessageUtils.logDebug(stackTraceElement.toString()));
    }

    public static void logInfo(Exception e) {
        MessageUtils.logInfo(e.getMessage());
        MessageUtils.logInfo(e.getStackTrace());
    }

    public static void logWarning(Exception e) {
        MessageUtils.logWarning(e.getMessage());
        MessageUtils.logWarning(e.getStackTrace());
    }

    public static void logSevere(Exception e) {
        MessageUtils.logSevere(e.getMessage());
        MessageUtils.logSevere(e.getStackTrace());
    }

    public static void logDebug(Exception e) {
        MessageUtils.logDebug(e.getMessage());
        MessageUtils.logDebug(e.getStackTrace());
    }

    public static void logInfo(String message, Throwable throwable) {
        MessageUtils.logInfo(message);
        MessageUtils.logInfo(throwable.getMessage());
        MessageUtils.logInfo(throwable.getStackTrace());
    }

    public static void logWarning(String message, Throwable throwable) {
        MessageUtils.logWarning(message);
        MessageUtils.logWarning(throwable.getMessage());
        MessageUtils.logWarning(throwable.getStackTrace());
    }

    public static void logSevere(String message, Throwable throwable) {
        MessageUtils.logSevere(message);
        MessageUtils.logSevere(throwable.getMessage());
        MessageUtils.logSevere(throwable.getStackTrace());
    }

    public static void logDebug(String message, Throwable throwable) {
        MessageUtils.logDebug(message);
        MessageUtils.logDebug(throwable.getMessage());
        MessageUtils.logDebug(throwable.getStackTrace());
    }

    public static void logInfoWithInfo(String message, Throwable throwable) {
        MessageUtils.logInfo(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable);
    }

    public static void logWarningWithInfo(String message, Throwable throwable) {
        MessageUtils.logWarning(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable);
    }

    public static void logSevereWithInfo(String message, Throwable throwable) {
        MessageUtils.logSevere(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable);
    }

    public static void logDebugWithInfo(String message, Throwable throwable) {
        MessageUtils.logDebug(message + (message.endsWith(" ") ? "" : " ") + throwable.getMessage(), throwable);
    }

    public static String loggedModulePrefix(ModuleLike module) {
        return "[" + module.getIdentifier() + "] ";
    }

    public static void logInfo(ModuleLike module, String message) {
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            MessageUtils.logInfo(MessageUtils.loggedModulePrefix(module) + line);
        }
    }

    public static void logWarning(ModuleLike module, String message) {
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            MessageUtils.logWarning(MessageUtils.loggedModulePrefix(module) + line);
        }
    }

    public static void logSevere(ModuleLike module, String message) {
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            MessageUtils.logSevere(MessageUtils.loggedModulePrefix(module) + line);
        }
    }

    public static void logDebug(ModuleLike module, String message) {
        message = message.replace("%newline%", "\n");
        for (String line : message.split("\n")) {
            MessageUtils.logDebug(MessageUtils.loggedModulePrefix(module) + line);
        }
    }

    public static void logInfo(ModuleLike module, StackTraceElement[] elements) {
        Arrays.stream(elements).forEach(stackTraceElement -> MessageUtils.logInfo(MessageUtils.loggedModulePrefix(module) + String.valueOf(stackTraceElement)));
    }

    public static void logWarning(ModuleLike module, StackTraceElement[] elements) {
        Arrays.stream(elements).forEach(stackTraceElement -> MessageUtils.logWarning(MessageUtils.loggedModulePrefix(module) + String.valueOf(stackTraceElement)));
    }

    public static void logSevere(ModuleLike module, StackTraceElement[] elements) {
        Arrays.stream(elements).forEach(stackTraceElement -> MessageUtils.logSevere(MessageUtils.loggedModulePrefix(module) + String.valueOf(stackTraceElement)));
    }

    public static void logDebug(ModuleLike module, StackTraceElement[] elements) {
        Arrays.stream(elements).forEach(stackTraceElement -> MessageUtils.logDebug(MessageUtils.loggedModulePrefix(module) + String.valueOf(stackTraceElement)));
    }

    public static void sendMessage(String to, String message) {
        CosmicSender user = UserUtils.getOrCreateSender(to).orElse(null);
        if (user == null) {
            MessageUtils.logWarning("Tried to send message to " + to + " but they are null.");
            return;
        }
        Singularity.getInstance().getMessenger().sendMessage(user, message);
    }

    public static void sendMessage(@Nullable String to, String otherUUID, String message) {
        CosmicSender user = UserUtils.getOrCreateSender(to).orElse(null);
        if (user == null) {
            MessageUtils.logWarning("Tried to send message to " + to + " but they are null.");
            return;
        }
        Singularity.getInstance().getMessenger().sendMessage(user, MessageUtils.replaceAllPlayerBungee(otherUUID, message));
    }

    public static String replaceAllPlayerBungee(CosmicSender user, String of) {
        if (user == null) {
            return of;
        }
        SingleSet<String, String> key = new SingleSet<String, String>(user.getUuid(), of);
        String cached = CACHE.getIfPresent(key);
        if (cached != null) {
            return cached;
        }
        String parsed = ModuleUtils.replacePlaceholders(user, of);
        CACHE.put(key, parsed);
        return parsed;
    }

    public static String replaceAllPlayerBungee(String to, String of) {
        CosmicSender user = UserUtils.getOrCreateSender(to).orElse(null);
        if (user == null) {
            MessageUtils.logWarning("Tried to replace placeholders for " + to + " but they are null.");
            return of;
        }
        return MessageUtils.replaceAllPlayerBungee(user, of);
    }

    public static String parseOnProxy(CosmicSender cosmicSender, String toParse) {
        CosmicPlayer player;
        if (cosmicSender instanceof CosmicPlayer) {
            player = (CosmicPlayer)cosmicSender;
        } else {
            try {
                player = UserUtils.getLoadedPlayersSet().first();
            }
            catch (Exception e) {
                player = null;
            }
        }
        if (player == null) {
            cosmicSender.getReplacements().addReplacement(toParse, "&cNo Valid Proxy-able Player");
        }
        ReturnableMessage message = ProxyParseMessageBuilder.build(player, toParse, cosmicSender);
        message.registerEventCall(m4 -> {
            String parsed = ProxyParseMessageBuilder.parse(m4);
            cosmicSender.getReplacements().addReplacement(toParse, parsed);
        });
        message.send();
        return cosmicSender.getReplacements().getReplacement(toParse, "Loading...");
    }

    public static String getListAsFormattedString(List<?> list) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String tag = String.valueOf(list.get(i));
            if (i < list.size() - 1) {
                builder.append(MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.LISTS_BASE.get().replace("%value%", tag));
                continue;
            }
            builder.append(MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.LISTS_LAST.get().replace("%value%", tag));
        }
        return builder.toString();
    }

    public static String removeExtraDot(String string) {
        String s2 = string.replace("..", ".");
        if (s2.endsWith(".")) {
            s2 = s2.substring(0, s2.lastIndexOf(46));
        }
        return s2;
    }

    public static String resize(String text, int digits) {
        try {
            digits = MessageUtils.getDigits(digits, text.length());
            return text.substring(0, digits);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static String truncate(String text, int digits) {
        if (!text.contains(".")) {
            return text;
        }
        try {
            digits = MessageUtils.getDigits(text.indexOf(".") + digits + 1, text.length());
            return text.substring(0, digits);
        }
        catch (Exception e) {
            return text;
        }
    }

    public static int getDigits(int start, int otherSize) {
        return Math.min(start, otherSize);
    }

    public static ConcurrentSkipListSet<String> getCompletion(List<String> of, String param) {
        return of.stream().filter(completion -> completion.toLowerCase(Locale.ROOT).startsWith(param.toLowerCase(Locale.ROOT))).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
    }

    public static ConcurrentSkipListSet<String> getCompletion(ConcurrentSkipListSet<String> of, String param) {
        return of.stream().filter(completion -> completion.toLowerCase(Locale.ROOT).startsWith(param.toLowerCase(Locale.ROOT))).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
    }

    public static String[] argsMinus(String[] args, int ... toRemove) {
        TreeMap<Integer, String> argsSet = new TreeMap<Integer, String>();
        for (int i = 0; i < args.length; ++i) {
            argsSet.put(i, args[i]);
        }
        for (int remove2 : toRemove) {
            argsSet.remove(remove2);
        }
        return argsSet.values().toArray(new String[0]);
    }

    public static String argsToStringMinus(String[] args, int ... toRemove) {
        return MessageUtils.normalize(MessageUtils.argsMinus(args, toRemove));
    }

    public static String argsToString(String[] args) {
        TreeMap<Integer, String> argsSet = new TreeMap<Integer, String>();
        for (int i = 0; i < args.length; ++i) {
            argsSet.put(i, args[i]);
        }
        return MessageUtils.normalize(argsSet);
    }

    public static String codedString(String text) {
        return MessageUtils.formatted(MessageUtils.newLined(Singularity.getInstance().getMessenger().codedString(text)));
    }

    public static String replaceAmpersand(String text) {
        String regex = "((&)([0-9a-fklmnor]))";
        return text.replaceAll(regex, "\u00a7$3");
    }

    public static String formatted(String string) {
        String[] strings = string.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].toLowerCase(Locale.ROOT).startsWith("<to_upper>")) {
                strings[i] = strings[i].toUpperCase(Locale.ROOT).replace("<TO_UPPER>", "");
            }
            if (!strings[i].toLowerCase(Locale.ROOT).startsWith("<to_lower>")) continue;
            strings[i] = strings[i].toLowerCase(Locale.ROOT).replace("<to_lower>", "");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i == strings.length - 1) {
                builder.append(strings[i]);
                continue;
            }
            builder.append(strings[i]).append(" ");
        }
        return builder.toString();
    }

    public static String newLined(String text) {
        try {
            return text.replace("%newline%", "\n");
        }
        catch (Exception e) {
            return text.replace("%newline%", "\n");
        }
    }

    public static boolean isCommand(String msg) {
        return msg.startsWith("/");
    }

    public static String normalize(String[] splitMsg) {
        int i = 0;
        StringBuilder text = new StringBuilder();
        for (String split : splitMsg) {
            ++i;
            if (split.isEmpty()) continue;
            if (i < splitMsg.length) {
                text.append(split).append(" ");
                continue;
            }
            text.append(split);
        }
        return text.toString();
    }

    public static String normalize(TreeSet<String> splitMsg) {
        int i = 0;
        StringBuilder text = new StringBuilder();
        for (String split : splitMsg) {
            ++i;
            if (split.isEmpty()) continue;
            if (i < splitMsg.size()) {
                text.append(split).append(" ");
                continue;
            }
            text.append(split);
        }
        return text.toString();
    }

    public static String normalize(TreeMap<Integer, String> splitMsg) {
        int i = 0;
        StringBuilder text = new StringBuilder();
        for (Integer split : splitMsg.keySet()) {
            ++i;
            if (splitMsg.get(split).isEmpty()) continue;
            if (i < splitMsg.size()) {
                text.append(splitMsg.get(split)).append(" ");
                continue;
            }
            text.append(splitMsg.get(split));
        }
        return text.toString();
    }

    public static boolean equalsAll(Object object, Object ... toEqual) {
        for (Object equal : toEqual) {
            if (object.equals(equal)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAll(Object object, Collection<Object> toEqual) {
        for (Object equal : toEqual) {
            if (object.equals(equal)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAny(Object object, Collection<?> toEqual) {
        for (Object equal : toEqual) {
            if (!object.equals(equal)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getStringListFromString(String string) {
        String[] strings = string.split(",");
        return List.of(strings);
    }

    public static boolean isNullOrLessThanEqualTo(Object[] thingArray, int lessThanOrEqualTo) {
        if (thingArray == null) {
            return true;
        }
        return thingArray.length <= lessThanOrEqualTo;
    }
}

