/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.util;

import de.leonhard.storage.shaded.jetbrains.annotations.NotNull;
import java.io.Writer;
import lombok.Generated;
import lombok.NonNull;

public class FastStringWriter
extends Writer {
    private final StringBuilder stringBuilder;

    public FastStringWriter() {
        this.stringBuilder = new StringBuilder();
    }

    public FastStringWriter(@NonNull StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder is marked non-null but is null");
        }
        this.stringBuilder = stringBuilder;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    @Override
    public FastStringWriter append(char c) {
        this.stringBuilder.append(c);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq, int start, int end) {
        this.stringBuilder.append(csq, start, end);
        return this;
    }

    @Override
    public FastStringWriter append(CharSequence csq) {
        this.stringBuilder.append(csq);
        return this;
    }

    @Override
    public void write(@NotNull String str, int off, int len) {
        this.stringBuilder.append(str, off, off + len);
    }

    @Override
    public void write(@NotNull String str) {
        this.stringBuilder.append(str);
    }

    @Override
    public void write(char @NotNull [] cbuf, int off, int len) {
        this.stringBuilder.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        this.stringBuilder.append(c);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Generated
    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }
}

