/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.leonhard.storage;

import gg.drak.thebase.lib.leonhard.storage.internal.FileData;
import gg.drak.thebase.lib.leonhard.storage.internal.FileType;
import gg.drak.thebase.lib.leonhard.storage.internal.FlatFile;
import gg.drak.thebase.lib.leonhard.storage.internal.editor.toml.TomlManager;
import gg.drak.thebase.lib.leonhard.storage.internal.provider.SimplixProviders;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ErrorHandler;
import gg.drak.thebase.lib.leonhard.storage.internal.settings.ReloadSettings;
import gg.drak.thebase.lib.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import gg.drak.thebase.lib.leonhard.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

public class Toml
extends FlatFile {
    public Toml(@NonNull Toml toml) {
        super(toml.getFile(), toml.pathSeparator());
        if (toml == null) {
            throw new NullPointerException("toml is marked non-null but is null");
        }
        this.fileData = toml.getFileData();
        this.pathPrefix = toml.getPathPrefixArray();
    }

    public Toml(String name, String path) {
        this(name, path, null);
    }

    public Toml(String name, String path, InputStream inputStream) {
        this(name, path, inputStream, null, null);
    }

    public Toml(@NonNull String name, @NonNull String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, null, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public Toml(@NonNull String name, @NonNull String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, null, pathPattern, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public Toml(@NonNull String name, @NonNull String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ErrorHandler errorHandler, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.TOML, pathPattern, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.create() && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        this.forceReload();
    }

    public Toml(File file) {
        super(file, FileType.TOML);
        this.create();
        this.forceReload();
    }

    @Override
    protected final Map<String, Object> readToMap() throws IOException {
        return TomlManager.read(this.getFile());
    }

    @Override
    protected final void write(FileData data) {
        try {
            TomlManager.write(data.toMap(), this.getFile());
        }
        catch (IOException ioException) {
            SimplixProviders.logger().printMessage("Exception while writing fileData to file '" + this.getName() + "'");
            SimplixProviders.logger().printMessage("In '" + FileUtils.getParentDirPath(this.file) + "'");
            SimplixProviders.logger().printStackTrace(ioException);
        }
    }
}

