/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.protocol.a;

import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.log.Log;
import gg.drak.thebase.lib.mysql.cj.protocol.MessageReader;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativePacketHeader;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativePacketPayload;
import gg.drak.thebase.lib.mysql.cj.util.StringUtils;
import java.io.IOException;
import java.util.Optional;

public class TracingPacketReader
implements MessageReader<NativePacketHeader, NativePacketPayload> {
    private static final int MAX_PACKET_DUMP_LENGTH = 1024;
    private MessageReader<NativePacketHeader, NativePacketPayload> packetReader;
    private Log log;

    public TracingPacketReader(MessageReader<NativePacketHeader, NativePacketPayload> packetReader, Log log) {
        this.packetReader = packetReader;
        this.log = log;
    }

    @Override
    public NativePacketHeader readHeader() throws IOException {
        return this.traceHeader(this.packetReader.readHeader());
    }

    @Override
    public NativePacketHeader probeHeader() throws IOException {
        return this.traceHeader(this.packetReader.probeHeader());
    }

    private NativePacketHeader traceHeader(NativePacketHeader hdr) throws IOException {
        StringBuilder traceMessageBuf = new StringBuilder();
        traceMessageBuf.append(Messages.getString("PacketReader.3"));
        traceMessageBuf.append(hdr.getMessageSize());
        traceMessageBuf.append(Messages.getString("PacketReader.4"));
        traceMessageBuf.append(StringUtils.dumpAsHex(hdr.getBuffer().array(), 4));
        this.log.logTrace(traceMessageBuf.toString());
        return hdr;
    }

    @Override
    public NativePacketPayload readMessage(Optional<NativePacketPayload> reuse, NativePacketHeader header) throws IOException {
        return this.traceMessage(this.packetReader.readMessage(reuse, header), header.getMessageSize(), reuse.isPresent());
    }

    @Override
    public NativePacketPayload probeMessage(Optional<NativePacketPayload> reuse, NativePacketHeader header) throws IOException {
        return this.traceMessage(this.packetReader.probeMessage(reuse, header), header.getMessageSize(), reuse.isPresent());
    }

    private NativePacketPayload traceMessage(NativePacketPayload buf, int packetLength, boolean reuse) throws IOException {
        StringBuilder traceMessageBuf = new StringBuilder();
        traceMessageBuf.append(Messages.getString(reuse ? "PacketReader.5" : "PacketReader.6"));
        traceMessageBuf.append(StringUtils.dumpAsHex(buf.getByteBuffer(), packetLength < 1024 ? packetLength : 1024));
        if (packetLength > 1024) {
            traceMessageBuf.append(Messages.getString("PacketReader.7"));
            traceMessageBuf.append(1024);
            traceMessageBuf.append(Messages.getString("PacketReader.8"));
        }
        this.log.logTrace(traceMessageBuf.toString());
        return buf;
    }

    @Override
    public byte getMessageSequence() {
        return this.packetReader.getMessageSequence();
    }

    @Override
    public void resetMessageSequence() {
        this.packetReader.resetMessageSequence();
    }

    @Override
    public MessageReader<NativePacketHeader, NativePacketPayload> undecorateAll() {
        return this.packetReader.undecorateAll();
    }

    @Override
    public MessageReader<NativePacketHeader, NativePacketPayload> undecorate() {
        return this.packetReader;
    }
}

