/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.xdevapi;

import gg.drak.thebase.lib.mysql.cj.MysqlxSession;
import gg.drak.thebase.lib.mysql.cj.conf.PropertySet;
import gg.drak.thebase.lib.mysql.cj.exceptions.ExceptionFactory;
import gg.drak.thebase.lib.mysql.cj.exceptions.WrongArgumentException;
import gg.drak.thebase.lib.mysql.cj.protocol.ColumnDefinition;
import gg.drak.thebase.lib.mysql.cj.protocol.ProtocolEntity;
import gg.drak.thebase.lib.mysql.cj.protocol.ResultBuilder;
import gg.drak.thebase.lib.mysql.cj.protocol.x.FetchDoneEntity;
import gg.drak.thebase.lib.mysql.cj.protocol.x.Notice;
import gg.drak.thebase.lib.mysql.cj.protocol.x.StatementExecuteOk;
import gg.drak.thebase.lib.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import gg.drak.thebase.lib.mysql.cj.result.BufferedRowList;
import gg.drak.thebase.lib.mysql.cj.result.DefaultColumnDefinition;
import gg.drak.thebase.lib.mysql.cj.result.Field;
import gg.drak.thebase.lib.mysql.cj.result.Row;
import gg.drak.thebase.lib.mysql.cj.result.RowList;
import gg.drak.thebase.lib.mysql.cj.xdevapi.DocResult;
import gg.drak.thebase.lib.mysql.cj.xdevapi.DocResultImpl;
import java.util.ArrayList;
import java.util.List;

public class DocResultBuilder
implements ResultBuilder<DocResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private DocResult result;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public DocResultBuilder(MysqlxSession sess) {
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public DocResult build() {
        this.result = new DocResultImpl((RowList)new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

