/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.storage.managers.datastores;

import gg.drak.thebase.storage.datastores.SimpleFlatDatastore;
import gg.drak.thebase.storage.documents.SimpleFlatDocument;
import gg.drak.thebase.storage.managers.datastores.IDataStoreManager;
import gg.drak.thebase.storage.resources.StorageResource;
import java.io.File;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDataStoreManager<T extends SimpleFlatDatastore<?, ?>>
implements IDataStoreManager<T> {
    final Class<T> classifier;
    final File parentDirectory;
    ConcurrentSkipListMap<String, T> loadedResources = new ConcurrentSkipListMap();

    public SimpleDataStoreManager(Class<T> classifier, File parentDirectory) {
        this.classifier = classifier;
        this.parentDirectory = parentDirectory;
    }

    public ConcurrentSkipListSet<T> getLoadedResourcesAsSet() {
        return new ConcurrentSkipListSet<T>(this.getLoadedResources().values());
    }

    @Override
    public boolean isAlreadyLoaded(String identifier) {
        return this.getLoadedResources().containsKey(identifier);
    }

    @Override
    public void load(T resource) {
        if (this.isAlreadyLoaded((String)((StorageResource)resource).getDiscriminator())) {
            return;
        }
        this.getLoadedResources().put((String)((StorageResource)resource).getDiscriminator(), resource);
    }

    @Override
    public void instantiateAndLoad(String identifier) {
        if (this.isAlreadyLoaded(identifier)) {
            return;
        }
        SimpleFlatDatastore resource = (SimpleFlatDatastore)this.instantiate(identifier);
    }

    @Override
    public void unload(String identifier) {
        if (!this.isAlreadyLoaded(identifier)) {
            return;
        }
        this.getLoadedResources().remove(identifier);
    }

    @Override
    @Nullable
    public T get(String identifier) {
        if (!this.isAlreadyLoaded(identifier)) {
            return null;
        }
        return (T)((SimpleFlatDatastore)this.getLoadedResources().get(identifier));
    }

    @Override
    @NotNull
    public T getOrLoad(String identifier) {
        StorageResource resource = this.get(identifier);
        if (resource != null) {
            return (T)resource;
        }
        resource = (SimpleFlatDatastore)this.instantiate(identifier);
        this.load((T)resource);
        return (T)resource;
    }

    @Override
    public void saveAll() {
        this.getLoadedResourcesAsSet().forEach(SimpleFlatDocument::save);
    }

    @Override
    @Generated
    public Class<T> getClassifier() {
        return this.classifier;
    }

    @Override
    @Generated
    public File getParentDirectory() {
        return this.parentDirectory;
    }

    @Generated
    public ConcurrentSkipListMap<String, T> getLoadedResources() {
        return this.loadedResources;
    }

    @Generated
    public void setLoadedResources(ConcurrentSkipListMap<String, T> loadedResources) {
        this.loadedResources = loadedResources;
    }
}

