/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.rolling;

import host.plas.bou.libs.logback.core.rolling.SizeAndTimeBasedFNATP;
import host.plas.bou.libs.logback.core.rolling.TimeBasedRollingPolicy;
import host.plas.bou.libs.logback.core.util.FileSize;

public class SizeAndTimeBasedRollingPolicy<E>
extends TimeBasedRollingPolicy<E> {
    FileSize maxFileSize;

    @Override
    public void start() {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP(SizeAndTimeBasedFNATP.Usage.EMBEDDED);
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            return;
        }
        this.addInfo("Archive files will be limited to [" + String.valueOf(this.maxFileSize) + "] each.");
        sizeAndTimeBasedFNATP.setMaxFileSize(this.maxFileSize);
        this.timeBasedFileNamingAndTriggeringPolicy = sizeAndTimeBasedFNATP;
        if (!this.isUnboundedTotalSizeCap() && this.totalSizeCap.getSize() < this.maxFileSize.getSize()) {
            this.addError("totalSizeCap of [" + String.valueOf(this.totalSizeCap) + "] is smaller than maxFileSize [" + String.valueOf(this.maxFileSize) + "] which is non-sensical");
            return;
        }
        super.start();
    }

    public void setMaxFileSize(FileSize aMaxFileSize) {
        this.maxFileSize = aMaxFileSize;
    }

    @Override
    public String toString() {
        return "c.q.l.core.rolling.SizeAndTimeBasedRollingPolicy@" + this.hashCode();
    }
}

