/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import gg.drak.thebase.events.BaseEventHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.streamline.api.SLAPI;
import net.streamline.api.base.module.BaseModule;
import net.streamline.base.runnables.PlayerChecker;
import net.streamline.platform.Messenger;
import net.streamline.platform.commands.ProperCommand;
import net.streamline.platform.listeners.PlatformListener;
import net.streamline.platform.messaging.ProxyPluginMessenger;
import net.streamline.platform.savables.ConsoleHolder;
import net.streamline.platform.savables.PlayerInterface;
import net.streamline.platform.savables.UserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import singularity.Singularity;
import singularity.command.CosmicCommand;
import singularity.data.players.CosmicPlayer;
import singularity.data.uuid.UuidInfo;
import singularity.data.uuid.UuidManager;
import singularity.events.CosmicEvent;
import singularity.events.server.ServerStartEvent;
import singularity.events.server.ServerStopEvent;
import singularity.interfaces.IProperEvent;
import singularity.interfaces.ISingularityExtension;
import singularity.messages.builders.ResourcePackMessageBuilder;
import singularity.objects.CosmicResourcePack;
import singularity.scheduler.TaskManager;
import singularity.utils.StorageUtils;
import singularity.utils.UserUtils;

public abstract class BasePlugin
extends Plugin
implements ISingularityExtension {
    private final ISingularityExtension.PlatformType platformType = ISingularityExtension.PlatformType.BUNGEE;
    private final ISingularityExtension.ServerType serverType = ISingularityExtension.ServerType.PROXY;
    private String name;
    private String version;
    private static BasePlugin instance;
    private SLAPI<CommandSender, ProxiedPlayer, BasePlugin, UserManager, Messenger> slapi;
    private UserManager userManager;
    private Messenger messenger;
    private ConsoleHolder consoleHolder;
    private PlayerInterface playerInterface;
    private static PlayerChecker playerChecker;
    private CosmicResourcePack resourcePack;

    public void onLoad() {
        File parentFile;
        File[] files;
        instance = this;
        this.setupProperties();
        String parentPath = this.getDataFolder().getParent();
        if (parentPath != null && (files = (parentFile = new File(parentPath)).listFiles(f -> {
            if (!f.isDirectory()) {
                return false;
            }
            if (f.getName().equals("StreamlineAPI")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Spigot")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Bungee")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Velocity")) {
                return true;
            }
            return f.getName().equals("streamlinecore");
        })) != null) {
            Arrays.stream(files).forEach(file -> file.renameTo(new File(parentPath, this.name)));
        }
        this.load();
    }

    public void setupProperties() {
        ConcurrentSkipListMap<String, String> properties = StorageUtils.readProperties();
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("name")) {
                this.name = value;
            }
            if (!key.equals("version")) continue;
            this.version = value;
        }
    }

    public void onEnable() {
        this.userManager = new UserManager();
        this.messenger = new Messenger();
        this.consoleHolder = new ConsoleHolder();
        this.playerInterface = new PlayerInterface();
        this.slapi = new SLAPI<CommandSender, ProxiedPlayer, BasePlugin, UserManager, Messenger>(this.getName(), this, this.getUserManager(), this.getMessenger(), this.getConsoleHolder(), this.getPlayerInterface(), BaseModule::new);
        this.getSlapi().setProxyMessenger(new ProxyPluginMessenger());
        BasePlugin.registerListener(new PlatformListener());
        TaskManager.init();
        this.getProxy().registerChannel(SLAPI.getApiChannel());
        playerChecker = new PlayerChecker();
        this.enable();
        this.fireStartEvent();
    }

    public void fireStartEvent() {
        ServerStartEvent e = (ServerStartEvent)new ServerStartEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    public void onDisable() {
        Singularity.getTpTicketFlusher().cancel();
        Singularity.getTpTicketPuller().cancel();
        UserUtils.syncAllUsers();
        UuidManager.getUuids().forEach(UuidInfo::save);
        this.getProxy().unregisterChannel(SLAPI.getApiChannel());
        this.disable();
        this.fireStopEvent();
        TaskManager.stop();
    }

    public void fireStopEvent() {
        ServerStopEvent e = (ServerStopEvent)new ServerStopEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    public abstract void enable();

    public abstract void disable();

    public abstract void load();

    public static void registerListener(Listener listener) {
        BasePlugin.getInstance().getProxy().getPluginManager().registerListener((Plugin)BasePlugin.getInstance(), listener);
    }

    @Override
    @NotNull
    public ConcurrentSkipListSet<CosmicPlayer> getOnlinePlayers() {
        ConcurrentSkipListSet<CosmicPlayer> players = new ConcurrentSkipListSet<CosmicPlayer>();
        for (ProxiedPlayer player : BasePlugin.onlinePlayers()) {
            CosmicPlayer cosmicPlayer = this.getUserManager().getOrCreatePlayer(player).orElse(null);
            if (cosmicPlayer == null) continue;
            players.add(cosmicPlayer);
        }
        return players;
    }

    @Override
    public ProperCommand createCommand(CosmicCommand command) {
        return new ProperCommand(command);
    }

    @Override
    public int getMaxPlayers() {
        return BasePlugin.getInstance().getProxy().getConfig().getPlayerLimit();
    }

    @Override
    public ConcurrentSkipListSet<String> getOnlinePlayerNames() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        this.getOnlinePlayers().forEach(a -> r.add(a.getCurrentName()));
        return r;
    }

    @Override
    public boolean isOfflineMode() {
        return !BasePlugin.getInstance().getProxy().getConfig().isOnlineMode();
    }

    @Override
    public long getConnectionThrottle() {
        return BasePlugin.getInstance().getProxy().getConfig().getThrottle();
    }

    public static List<ProxiedPlayer> onlinePlayers() {
        return new ArrayList<ProxiedPlayer>(BasePlugin.getInstance().getProxy().getPlayers());
    }

    public static List<ProxiedPlayer> playersOnServer(String serverName) {
        return new ArrayList<ProxiedPlayer>(BasePlugin.getInstance().getProxy().getServerInfo(serverName).getPlayers());
    }

    public static ProxiedPlayer getPlayer(String uuid) {
        for (ProxiedPlayer player : BasePlugin.onlinePlayers()) {
            if (!player.getUniqueId().toString().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Optional<ProxiedPlayer> getPlayerByName(String name) {
        return Optional.ofNullable(BasePlugin.getInstance().getProxy().getPlayer(name));
    }

    @Nullable
    public static ProxiedPlayer getPlayerExact(@NotNull String name) {
        if (BasePlugin.getPlayerByName(name).isEmpty()) {
            return null;
        }
        return BasePlugin.getPlayerByName(name).get();
    }

    public static ProxiedPlayer getPlayer(CommandSender sender) {
        return BasePlugin.getInstance().getProxy().getPlayer(sender.getName());
    }

    @Override
    public boolean getOnlineMode() {
        return BasePlugin.getInstance().getProxy().getConfig().isOnlineMode();
    }

    @Override
    public void shutdown() {
        BasePlugin.getInstance().getProxy().stop();
    }

    @Override
    public int broadcast(@NotNull String message, @NotNull String permission) {
        int people = 0;
        for (ProxiedPlayer player : BasePlugin.onlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            this.getMessenger().sendMessage((CommandSender)player, message);
            ++people;
        }
        return people;
    }

    @Override
    public boolean serverHasPlugin(String plugin) {
        return BasePlugin.getInstance().getProxy().getPluginManager().getPlugin(plugin) != null;
    }

    @Override
    public boolean equalsAnyServer(String servername) {
        return this.getServerNames().contains(servername);
    }

    @Override
    public void fireEvent(IProperEvent<?> event) {
        if (!(event.getEvent() instanceof Event)) {
            return;
        }
        Event e = (Event)event.getEvent();
        BasePlugin.getInstance().getProxy().getPluginManager().callEvent(e);
    }

    @Override
    public void fireEvent(CosmicEvent event) {
        this.fireEvent(event, true);
    }

    @Override
    public void fireEvent(CosmicEvent event, boolean async) {
        try {
            BaseEventHandler.fireEvent(event);
        }
        catch (Exception e) {
            this.handleMisSync(event, async);
        }
    }

    @Override
    public void handleMisSync(CosmicEvent event, boolean async) {
        BaseEventHandler.fireEvent(event);
    }

    @Override
    public ConcurrentSkipListSet<String> getServerNames() {
        return new ConcurrentSkipListSet<String>(BasePlugin.getInstance().getProxy().getServers().keySet());
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, CosmicPlayer player) {
        ProxiedPlayer p = BasePlugin.getPlayer(player.getUuid());
        this.sendResourcePack(resourcePack, p);
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, String uuid) {
        ProxiedPlayer p = BasePlugin.getPlayer(uuid);
        this.sendResourcePack(resourcePack, p);
    }

    public void sendResourcePack(CosmicResourcePack resourcePack, ProxiedPlayer player) {
        if (player == null) {
            return;
        }
        CosmicPlayer streamPlayer = this.getUserManager().getOrCreatePlayer(player).orElse(null);
        if (streamPlayer == null) {
            return;
        }
        ResourcePackMessageBuilder.build(streamPlayer, true, streamPlayer, resourcePack).send();
    }

    @Override
    public ClassLoader getMainClassLoader() {
        return this.getProxy().getClass().getClassLoader();
    }

    public static ConcurrentSkipListMap<String, ProxiedPlayer> getPlayersByUUID() {
        ConcurrentSkipListMap<String, ProxiedPlayer> map = new ConcurrentSkipListMap<String, ProxiedPlayer>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            map.put(player.getUniqueId().toString(), player);
        }
        return map;
    }

    @Override
    public java.util.logging.Logger getLoggerLogger() {
        return this.getProxy().getLogger();
    }

    @Override
    public Logger getSLFLogger() {
        return null;
    }

    @Override
    public ISingularityExtension.PlatformType getPlatformType() {
        return this.platformType;
    }

    @Override
    public ISingularityExtension.ServerType getServerType() {
        return this.serverType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public static BasePlugin getInstance() {
        return instance;
    }

    public SLAPI<CommandSender, ProxiedPlayer, BasePlugin, UserManager, Messenger> getSlapi() {
        return this.slapi;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public ConsoleHolder getConsoleHolder() {
        return this.consoleHolder;
    }

    public PlayerInterface getPlayerInterface() {
        return this.playerInterface;
    }

    public static PlayerChecker getPlayerChecker() {
        return playerChecker;
    }

    public static void setPlayerChecker(PlayerChecker playerChecker) {
        BasePlugin.playerChecker = playerChecker;
    }

    public CosmicResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public void setResourcePack(CosmicResourcePack resourcePack) {
        this.resourcePack = resourcePack;
    }
}

