/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import org.junit.jupiter.params.converter.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;

class StringToBooleanConverter
implements StringToObjectConverter {
    StringToBooleanConverter() {
    }

    @Override
    public boolean canConvert(Class<?> targetType) {
        return targetType == Boolean.class;
    }

    @Override
    public Object convert(String source, Class<?> targetType) {
        boolean isTrue = "true".equalsIgnoreCase(source);
        Preconditions.condition(isTrue || "false".equalsIgnoreCase(source), () -> "String must be 'true' or 'false' (ignoring case): " + source);
        return isTrue;
    }
}

