/*
 * Decompiled with CFR 0.152.
 */
package singularity.command;

import java.io.File;
import singularity.Singularity;
import singularity.command.CommandHandler;
import singularity.command.CosmicCommand;
import singularity.modules.ModuleLike;

public abstract class ModuleCommand
extends CosmicCommand {
    private final ModuleLike owningModule;

    public ModuleCommand(ModuleLike module, String base, String permission, String ... aliases) {
        this(module, base, permission, new File(module.getDataFolder(), Singularity.getCommandsFolderChild()), aliases);
    }

    public ModuleCommand(ModuleLike module, String base, String permission, File parentDirectory, String ... aliases) {
        super(module.getIdentifier(), base, permission, parentDirectory, aliases);
        this.owningModule = module;
    }

    public void modulize() {
        this.getOwningModule().addCommand(this);
    }

    public void demodulize() {
        this.getOwningModule().removeCommand(this);
    }

    @Override
    public void register() {
        if (!this.isEnabled()) {
            return;
        }
        CommandHandler.registerModuleCommand(this);
        this.modulize();
    }

    @Override
    public void unregister() {
        if (!this.isEnabled() && !CommandHandler.getLoadedModuleCommands().containsKey(this.getIdentifier())) {
            return;
        }
        CommandHandler.unregisterModuleCommand(this);
        this.demodulize();
    }

    @Override
    public void disable() {
        CommandHandler.unregisterModuleCommand(this);
    }

    public ModuleLike getOwningModule() {
        return this.owningModule;
    }
}

