/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players.permissions;

import org.jetbrains.annotations.NotNull;
import singularity.data.console.CosmicSender;

public class SenderPermissions
implements Comparable<SenderPermissions> {
    private CosmicSender sender;
    private boolean bypassingPermissions;

    public SenderPermissions(CosmicSender sender) {
        this.sender = sender;
        this.bypassingPermissions = false;
    }

    @Override
    public int compareTo(@NotNull SenderPermissions o) {
        return this.sender.compareTo(o.getSender());
    }

    public boolean hasPermission(String permission) {
        if (this.isBypassingPermissions()) {
            return true;
        }
        return this.sender.asReal().hasPermission(permission);
    }

    public void addPermission(String permission) {
        this.sender.asReal().addPermission(permission);
    }

    public void removePermission(String permission) {
        this.sender.asReal().removePermission(permission);
    }

    public CosmicSender getSender() {
        return this.sender;
    }

    public boolean isBypassingPermissions() {
        return this.bypassingPermissions;
    }

    public void setSender(CosmicSender sender) {
        this.sender = sender;
    }

    public void setBypassingPermissions(boolean bypassingPermissions) {
        this.bypassingPermissions = bypassingPermissions;
    }
}

