/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.teleportation;

import gg.drak.thebase.objects.Identifiable;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.CosmicLocation;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.data.server.CosmicServer;
import singularity.redis.OwnRedisClient;
import singularity.redis.RedisMessage;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class TPTicket
implements Identifiable {
    public static final String REDIS_CHANNEL = "tp-ticket:put";
    private String identifier;
    private CosmicServer targetServer;
    private PlayerWorld targetWorld;
    private WorldPosition targetLocation;
    private PlayerRotation targetRotation;
    private Date createDate;
    private static ConcurrentSkipListSet<TPTicket> pendingTickets = new ConcurrentSkipListSet();

    public TPTicket(String identifier, CosmicServer targetServer, PlayerWorld targetWorld, WorldPosition targetLocation, PlayerRotation targetRotation, Date createDate) {
        this.identifier = identifier;
        this.targetServer = targetServer;
        this.targetWorld = targetWorld;
        this.targetLocation = targetLocation;
        this.targetRotation = targetRotation;
        this.createDate = createDate;
    }

    public TPTicket(String identifier, CosmicLocation location, Date createDate) {
        this(identifier, location.getServer(), location.getWorld(), location.getPosition(), location.getRotation(), createDate);
    }

    public TPTicket(String identifier, CosmicServer targetServer, PlayerWorld targetWorld, WorldPosition targetLocation, PlayerRotation targetRotation) {
        this(identifier, targetServer, targetWorld, targetLocation, targetRotation, new Date());
    }

    public TPTicket(String identifier, CosmicLocation location) {
        this(identifier, location.getServer(), location.getWorld(), location.getPosition(), location.getRotation());
    }

    public Optional<CosmicServer> getServerOfPlayer() {
        return UserUtils.getPlayer(this.getIdentifier()).map(CosmicPlayer::getServer);
    }

    public void post() {
        if (!TPTicket.isUseRedis()) {
            Singularity.getMainDatabase().postTPTicketAsync(this);
        } else {
            this.getServerOfPlayer().ifPresent(s2 -> UserUtils.getPlayer(this.getIdentifier()).ifPresent(p -> {
                if (Singularity.isProxy() || !s2.equals(TPTicket.getOwnServer())) {
                    if (Singularity.isProxy() && !s2.equals(this.getTargetServer())) {
                        p.connect(this.getTargetServer());
                    }
                    RedisMessage redisMessage = TPTicket.toRedisMessage(this);
                    redisMessage.send();
                } else if (s2.equals(this.getTargetServer())) {
                    Singularity.getInstance().getUserManager().teleport((CosmicPlayer)p, this.toLocation());
                }
            }));
        }
    }

    public CosmicLocation toLocation() {
        return new CosmicLocation(this.getTargetServer(), this.getTargetWorld(), this.getTargetLocation(), this.getTargetRotation());
    }

    public void clear() {
        Singularity.getMainDatabase().clearTPTicketAsync(this.getIdentifier());
        this.unpend();
    }

    public void onFromRedis() {
        CosmicPlayer player = UserUtils.getPlayer(this.getIdentifier()).orElse(null);
        if (Singularity.isProxy()) {
            if (player == null) {
                MessageUtils.logWarning("Player with UUID " + this.getIdentifier() + " not found for teleportation ticket.");
                this.clear();
                return;
            }
            if (!player.getServer().equals(this.getTargetServer())) {
                player.connect(this.getTargetServer());
            }
            this.unpend();
        } else {
            if (!this.getTargetServer().equals(TPTicket.getOwnServer())) {
                this.unpend();
                return;
            }
            if (player == null) {
                TPTicket.pend(this);
            } else {
                Singularity.getInstance().getUserManager().teleport(player, this.toLocation());
                this.clear();
            }
        }
    }

    public static CosmicServer getOwnServer() {
        return GivenConfigs.getServer().getCosmicServer();
    }

    public static boolean isUseRedis() {
        return OwnRedisClient.isConnected();
    }

    public void unpend() {
        TPTicket.unpend(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TPTicket)) {
            return false;
        }
        TPTicket other = (TPTicket)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    public static long getOldMillis() {
        return 7000L;
    }

    public Date getOldDate() {
        return new Date(this.getCreateDate().getTime() + TPTicket.getOldMillis());
    }

    public boolean isOld() {
        Date now = new Date();
        return now.after(this.getOldDate());
    }

    public static TPTicket fromRedisMessage(RedisMessage redisMessage) {
        String content = redisMessage.getMessage();
        String[] parts = content.split(";");
        String identifier = parts[0];
        String serverIdentifier = parts[1];
        CosmicServer server = new CosmicServer(serverIdentifier);
        String worldName = parts[2];
        PlayerWorld targetWorld = new PlayerWorld(worldName);
        double x = Double.parseDouble(parts[3]);
        double y = Double.parseDouble(parts[4]);
        double z = Double.parseDouble(parts[5]);
        WorldPosition position = new WorldPosition(x, y, z);
        float yaw = Float.parseFloat(parts[6]);
        float pitch = Float.parseFloat(parts[7]);
        PlayerRotation rotation = new PlayerRotation(yaw, pitch);
        return new TPTicket(identifier, server, targetWorld, position, rotation);
    }

    public static RedisMessage toRedisMessage(TPTicket tpTicket) {
        String content = String.join((CharSequence)";", tpTicket.getIdentifier(), tpTicket.getTargetServer().getIdentifier(), tpTicket.getTargetWorld().getIdentifier(), String.valueOf(tpTicket.getTargetLocation().getX()), String.valueOf(tpTicket.getTargetLocation().getY()), String.valueOf(tpTicket.getTargetLocation().getZ()), String.valueOf(tpTicket.getTargetRotation().getYaw()), String.valueOf(tpTicket.getTargetRotation().getPitch())) + ";";
        return new RedisMessage(REDIS_CHANNEL, content);
    }

    public static void pend(TPTicket ticket) {
        if (ticket == null) {
            return;
        }
        if (TPTicket.isPending(ticket)) {
            TPTicket.unpend(ticket);
        }
        pendingTickets.add(ticket);
    }

    public static void unpend(TPTicket ticket) {
        if (ticket == null) {
            return;
        }
        TPTicket.getPendingTickets().removeIf(t2 -> t2.equals(ticket));
    }

    public static TPTicket get(String uuid) {
        return TPTicket.getPendingTickets().stream().filter(t2 -> t2.getIdentifier().equalsIgnoreCase(uuid)).findFirst().orElse(null);
    }

    public static boolean isPending(TPTicket ticket) {
        return TPTicket.getPendingTickets().stream().anyMatch(t2 -> t2.equals(ticket));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public CosmicServer getTargetServer() {
        return this.targetServer;
    }

    public PlayerWorld getTargetWorld() {
        return this.targetWorld;
    }

    public WorldPosition getTargetLocation() {
        return this.targetLocation;
    }

    public PlayerRotation getTargetRotation() {
        return this.targetRotation;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setTargetServer(CosmicServer targetServer) {
        this.targetServer = targetServer;
    }

    public void setTargetWorld(PlayerWorld targetWorld) {
        this.targetWorld = targetWorld;
    }

    public void setTargetLocation(WorldPosition targetLocation) {
        this.targetLocation = targetLocation;
    }

    public void setTargetRotation(PlayerRotation targetRotation) {
        this.targetRotation = targetRotation;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public static ConcurrentSkipListSet<TPTicket> getPendingTickets() {
        return pendingTickets;
    }

    public static void setPendingTickets(ConcurrentSkipListSet<TPTicket> pendingTickets) {
        TPTicket.pendingTickets = pendingTickets;
    }
}

