/*
 * Decompiled with CFR 0.152.
 */
package singularity.database.modules;

import gg.drak.thebase.objects.Identifiable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import singularity.Singularity;
import singularity.database.CoreDBOperator;
import singularity.database.DatabaseType;
import singularity.database.modules.ResourceGetter;

public abstract class DBKeeper<T extends Identifiable>
implements Identifiable {
    private String identifier;
    private ResourceGetter<T> getter;

    public DBKeeper(String identifier, ResourceGetter<T> getter) {
        this.identifier = identifier;
        this.getter = getter;
    }

    public static CoreDBOperator getDatabase() {
        return Singularity.getMainDatabase();
    }

    public static DatabaseType getDatabaseType() {
        return DBKeeper.getDatabase().getConnectorSet().getType();
    }

    public void ensureTables() {
        if (DBKeeper.getDatabaseType() == DatabaseType.MYSQL) {
            this.ensureMysqlTables();
        } else if (DBKeeper.getDatabaseType() == DatabaseType.SQLITE) {
            this.ensureSqliteTables();
        }
    }

    public abstract void ensureMysqlTables();

    public abstract void ensureSqliteTables();

    public void save(T obj, boolean async) {
        if (async) {
            CompletableFuture.runAsync(() -> this.saveRaw(obj));
        } else {
            this.saveRaw(obj);
        }
    }

    public void save(T obj) {
        this.save(obj, true);
    }

    public void saveRaw(T obj) {
        this.ensureTables();
        if (DBKeeper.getDatabaseType() == DatabaseType.MYSQL) {
            this.saveMysql(obj);
        } else if (DBKeeper.getDatabaseType() == DatabaseType.SQLITE) {
            this.saveSqlite(obj);
        }
    }

    public String getTablePrefix() {
        return DBKeeper.getDatabase().getConnectorSet().getTablePrefix();
    }

    public String injectTablePrefix(String statement) {
        return statement.replace("%table_prefix%", this.getTablePrefix());
    }

    public String getDatabaseName() {
        return DBKeeper.getDatabase().getConnectorSet().getDatabase();
    }

    public String injectDatabaseName(String statement) {
        return statement.replace("%database_name%", this.getDatabaseName());
    }

    public abstract void saveMysql(T var1);

    public abstract void saveSqlite(T var1);

    public CompletableFuture<Optional<T>> load(String identifier) {
        return CompletableFuture.supplyAsync(() -> this.loadRaw(identifier));
    }

    public Optional<T> loadRaw(String identifier) {
        this.ensureTables();
        if (DBKeeper.getDatabaseType() == DatabaseType.MYSQL) {
            return this.loadMysql(identifier);
        }
        if (DBKeeper.getDatabaseType() == DatabaseType.SQLITE) {
            return this.loadSqlite(identifier);
        }
        return Optional.of((Identifiable)this.getGetter().apply(identifier));
    }

    public abstract Optional<T> loadMysql(String var1);

    public abstract Optional<T> loadSqlite(String var1);

    public boolean forceExists(String identifier) {
        return this.exists(identifier).join();
    }

    public CompletableFuture<Boolean> exists(String identifier) {
        return CompletableFuture.supplyAsync(() -> this.existsRaw(identifier));
    }

    public boolean existsRaw(String identifier) {
        this.ensureTables();
        if (DBKeeper.getDatabaseType() == DatabaseType.MYSQL) {
            return this.existsMysql(identifier);
        }
        if (DBKeeper.getDatabaseType() == DatabaseType.SQLITE) {
            return this.existsSqlite(identifier);
        }
        return false;
    }

    public abstract boolean existsMysql(String var1);

    public abstract boolean existsSqlite(String var1);

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public ResourceGetter<T> getGetter() {
        return this.getter;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setGetter(ResourceGetter<T> getter) {
        this.getter = getter;
    }
}

