/*
 * Decompiled with CFR 0.152.
 */
package singularity.objects.world;

import org.jetbrains.annotations.NotNull;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;

public class CosmicBlock
implements Comparable<CosmicBlock> {
    private PlayerWorld world;
    private WorldPosition location;
    private String type;

    public CosmicBlock(PlayerWorld world, WorldPosition location, String type) {
        this.world = world;
        this.location = location;
        this.type = type;
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public double getZ() {
        return this.location.getZ();
    }

    public String getWorldName() {
        return this.world.getIdentifier();
    }

    public CosmicBlock setX(double x) {
        this.location.setX(x);
        return this;
    }

    public CosmicBlock setY(double y) {
        this.location.setY(y);
        return this;
    }

    public CosmicBlock setZ(double z) {
        this.location.setZ(z);
        return this;
    }

    public CosmicBlock setWorld(PlayerWorld world) {
        this.world = world;
        return this;
    }

    public CosmicBlock setWorld(String worldName) {
        this.world = new PlayerWorld(worldName);
        return this;
    }

    public double distance(CosmicBlock other) {
        if (other == null) {
            return -1.0;
        }
        return this.getLocation().distance(other.getLocation());
    }

    @Override
    public int compareTo(@NotNull CosmicBlock o) {
        if (this.world != o.world) {
            return this.world.compareTo(o.world);
        }
        return this.location.compareTo(o.location);
    }

    public PlayerWorld getWorld() {
        return this.world;
    }

    public WorldPosition getLocation() {
        return this.location;
    }

    public String getType() {
        return this.type;
    }

    public void setLocation(WorldPosition location) {
        this.location = location;
    }

    public void setType(String type) {
        this.type = type;
    }
}

