/*
 * Decompiled with CFR 0.152.
 */
package singularity.utils;

import java.util.Optional;
import java.util.UUID;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.holders.HoldersHolder;
import singularity.holders.builtin.CosmicGeyserHolder;
import singularity.utils.UUIDFetcher;

public class UuidUtils {
    public static UUID randomUuid() {
        return UUID.randomUUID();
    }

    public static String randomStringUuid() {
        return UuidUtils.randomUuid().toString();
    }

    public static boolean isUuid(String thing) {
        try {
            UUID.fromString(thing);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String toUuid(String name) {
        if (UuidUtils.isUuid(name)) {
            return name;
        }
        if (UuidUtils.isConsole(name)) {
            return UuidUtils.getConsoleUUID();
        }
        if (UuidUtils.isBedrockName(name)) {
            return UuidUtils.getBedrockUUIDFromUsername(name);
        }
        UUID uuid = UUIDFetcher.getUUID(name);
        if (uuid == null) {
            return null;
        }
        return uuid.toString();
    }

    public static String toName(String uuid) {
        if (UuidUtils.isUuid(uuid)) {
            if (UuidUtils.isBedrockUUID(uuid)) {
                return UuidUtils.getUsernameFromBedrockUUID(uuid);
            }
            return UUIDFetcher.getName(uuid);
        }
        if (UuidUtils.isConsole(uuid)) {
            return UuidUtils.getConsoleName();
        }
        return null;
    }

    public static boolean isConsole(String thing) {
        return thing.equals(UuidUtils.getConsoleName()) || thing.equals(UuidUtils.getConsoleUUID());
    }

    public static String getConsoleName() {
        return GivenConfigs.getMainConfig().getConsoleName();
    }

    public static String getConsoleUUID() {
        return GivenConfigs.getMainConfig().getConsoleDiscriminator();
    }

    public static boolean isOfflineMode() {
        return Singularity.isOfflineMode();
    }

    public static boolean isNoInternet() {
        return GivenConfigs.getMainConfig().isNoInternet();
    }

    public static boolean isValidPlayer(CosmicSender sender) {
        if (sender == null) {
            return false;
        }
        if (sender.getIdentifier() == null || sender.getCurrentName() == null || sender.getCurrentName().isBlank()) {
            return false;
        }
        if (!(sender instanceof CosmicPlayer)) {
            return sender.getIdentifier().equals(UuidUtils.getConsoleUUID()) && sender.getCurrentName().equals(UuidUtils.getConsoleName());
        }
        CosmicPlayer player = (CosmicPlayer)sender;
        if (UuidUtils.isOfflineMode()) {
            return true;
        }
        if (UuidUtils.isBedrockUUID(player.getUuid())) {
            return true;
        }
        String name = UUIDFetcher.getName(player.getIdentifier());
        return name != null && !name.isBlank() && name.equals(player.getCurrentName());
    }

    public static boolean isValidPlayerName(String playerName) {
        if (playerName == null) {
            return false;
        }
        if (playerName.isBlank()) {
            return false;
        }
        if (UuidUtils.isNoInternet()) {
            return true;
        }
        if (UuidUtils.isOfflineMode()) {
            return true;
        }
        if (UuidUtils.isBedrockName(playerName)) {
            return true;
        }
        UUID uuid = UUIDFetcher.getUUID(playerName);
        return uuid != null;
    }

    public static boolean isValidPlayerUUID(String uuid) {
        if (uuid == null) {
            return false;
        }
        if (uuid.isBlank()) {
            return false;
        }
        if (UuidUtils.isNoInternet()) {
            return true;
        }
        if (UuidUtils.isOfflineMode()) {
            return true;
        }
        if (UuidUtils.isBedrockUUID(uuid)) {
            return true;
        }
        String name = UUIDFetcher.getName(uuid);
        return name != null;
    }

    public static Optional<CosmicGeyserHolder> getGeyserHolder() {
        return Optional.ofNullable(HoldersHolder.getGeyserHolder());
    }

    public static boolean isBedrockUUID(String uuid) {
        return UuidUtils.getGeyserHolder().map(h2 -> h2.isBedrockUUID(uuid)).orElse(false);
    }

    public static boolean isBedrockName(String name) {
        return UuidUtils.getGeyserHolder().map(h2 -> h2.isBedrockName(name)).orElse(false);
    }

    public static String getBedrockPrefix() {
        return UuidUtils.getGeyserHolder().map(CosmicGeyserHolder::getBedrockPrefix).orElse(null);
    }

    public static String getUsernameFromBedrockUUID(String uuid) {
        return UuidUtils.getGeyserHolder().map(h2 -> h2.getUsernameFromBedrockUUID(uuid)).orElse(null);
    }

    public static String getBedrockUUIDFromUsername(String name) {
        return UuidUtils.getGeyserHolder().map(h2 -> h2.getBedrockUUIDFromUsername(name)).orElse(null);
    }
}

