/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.events;

import gg.drak.thebase.events.BaseEventListener;
import gg.drak.thebase.events.components.BaseEvent;
import gg.drak.thebase.events.processing.BaseEventExecutor;
import gg.drak.thebase.events.processing.BaseEventPriority;
import gg.drak.thebase.events.processing.exception.BaseEventException;
import gg.drak.thebase.objects.handling.IEventable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class RegisteredListener<T extends IEventable>
implements Comparable<RegisteredListener<T>> {
    private static int masterIndex = 0;
    private final BaseEventListener listener;
    private final BaseEventPriority priority;
    private final BaseEventExecutor executor;
    private final boolean ignoreCancelled;
    private final int index;
    private final T eventable;

    public RegisteredListener(@NotNull BaseEventListener listener, @NotNull BaseEventExecutor executor, @NotNull BaseEventPriority priority, T eventable, boolean ignoreCancelled) {
        this.listener = listener;
        this.priority = priority;
        this.executor = executor;
        this.ignoreCancelled = ignoreCancelled;
        RegisteredListener.setMasterIndex(RegisteredListener.getMasterIndex() + 1);
        this.index = RegisteredListener.getMasterIndex();
        this.eventable = eventable;
    }

    @NotNull
    public BaseEventListener getListener() {
        return this.listener;
    }

    @NotNull
    public T getEventable() {
        return this.eventable;
    }

    @NotNull
    public BaseEventPriority getPriority() {
        return this.priority;
    }

    public void callEvent(@NotNull BaseEvent event) throws BaseEventException {
        this.executor.execute(this.listener, event);
    }

    public boolean isIgnoringCancelled() {
        return this.ignoreCancelled;
    }

    @Override
    public int compareTo(@NotNull RegisteredListener o) {
        return Integer.compare(this.index, o.index);
    }

    @Generated
    public static int getMasterIndex() {
        return masterIndex;
    }

    @Generated
    public static void setMasterIndex(int masterIndex) {
        RegisteredListener.masterIndex = masterIndex;
    }
}

