/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.protocol.a;

import gg.drak.thebase.lib.mysql.cj.BindValue;
import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.exceptions.ExceptionFactory;
import gg.drak.thebase.lib.mysql.cj.exceptions.WrongArgumentException;
import gg.drak.thebase.lib.mysql.cj.protocol.InternalTime;
import gg.drak.thebase.lib.mysql.cj.protocol.Message;
import gg.drak.thebase.lib.mysql.cj.protocol.a.AbstractValueEncoder;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativeConstants;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativePacketPayload;
import gg.drak.thebase.lib.mysql.cj.util.StringUtils;
import gg.drak.thebase.lib.mysql.cj.util.TimeUtil;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class OffsetTimeValueEncoder
extends AbstractValueEncoder {
    @Override
    public String getString(BindValue binding) {
        switch (binding.getMysqlType()) {
            case NULL: {
                return "null";
            }
            case TIME: {
                StringBuilder sb = new StringBuilder("'");
                sb.append(this.adjustLocalTime(((OffsetTime)binding.getValue()).withOffsetSameInstant(ZoneOffset.ofTotalSeconds(this.serverSession.getDefaultTimeZone().getRawOffset() / 1000)).toLocalTime(), binding.getField()).format(TimeUtil.TIME_FORMATTER_WITH_OPTIONAL_MICROS));
                sb.append("'");
                return sb.toString();
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                StringBuilder sb = new StringBuilder("'");
                sb.append(((OffsetTime)binding.getValue()).format((Boolean)this.sendFractionalSeconds.getValue() != false && ((OffsetTime)binding.getValue()).getNano() > 0 ? TimeUtil.TIME_FORMATTER_WITH_NANOS_WITH_OFFSET : TimeUtil.TIME_FORMATTER_NO_FRACT_WITH_OFFSET));
                sb.append("'");
                return sb.toString();
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        NativePacketPayload intoPacket = (NativePacketPayload)msg;
        switch (binding.getMysqlType()) {
            case TIME: {
                this.writeTime(msg, InternalTime.from(this.adjustLocalTime(((OffsetTime)binding.getValue()).withOffsetSameInstant(ZoneOffset.ofTotalSeconds(this.serverSession.getDefaultTimeZone().getRawOffset() / 1000)).toLocalTime(), binding.getField())));
                return;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                intoPacket.writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, StringUtils.getBytes(((OffsetTime)binding.getValue()).format((Boolean)this.sendFractionalSeconds.getValue() != false && ((OffsetTime)binding.getValue()).getNano() > 0 ? TimeUtil.TIME_FORMATTER_WITH_NANOS_WITH_OFFSET : TimeUtil.TIME_FORMATTER_NO_FRACT_WITH_OFFSET), (String)this.charEncoding.getValue()));
                return;
            }
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("PreparedStatement.67", new Object[]{binding.getValue().getClass().getName(), binding.getMysqlType().toString()}), this.exceptionInterceptor);
    }

    @Override
    public void encodeAsQueryAttribute(Message msg, BindValue binding) {
        this.writeTime(msg, InternalTime.from((OffsetTime)binding.getValue()));
    }
}

