/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.model.processor;

import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.joran.GenericXMLConfigurator;
import host.plas.bou.libs.logback.core.joran.event.SaxEvent;
import host.plas.bou.libs.logback.core.joran.event.SaxEventRecorder;
import host.plas.bou.libs.logback.core.joran.spi.JoranException;
import host.plas.bou.libs.logback.core.joran.util.ConfigurationWatchListUtil;
import host.plas.bou.libs.logback.core.model.IncludeModel;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerBase;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerException;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.util.Loader;
import host.plas.bou.libs.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public class IncludeModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    private String attributeInUse;
    private boolean optional;

    public IncludeModelHandler(Context context) {
        super(context);
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        return new IncludeModelHandler(context);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        IncludeModel includeModel = (IncludeModel)model;
        this.optional = OptionHelper.toBoolean(includeModel.getOptional(), false);
        if (!this.checkAttributes(includeModel)) {
            this.inError = true;
            return;
        }
        InputStream in = this.getInputStream(mic, includeModel);
        if (in == null) {
            this.inError = true;
            return;
        }
        SaxEventRecorder recorder = null;
        try {
            recorder = this.populateSaxEventRecorder(in);
            List<SaxEvent> saxEvents = recorder.getSaxEventList();
            if (saxEvents.isEmpty()) {
                this.addWarn("Empty sax event list");
                return;
            }
            Supplier<? extends GenericXMLConfigurator> jcSupplier = mic.getConfiguratorSupplier();
            if (jcSupplier == null) {
                this.addError("null configurator supplier. Abandoning inclusion of [" + this.attributeInUse + "]");
                this.inError = true;
                return;
            }
            GenericXMLConfigurator genericXMLConfigurator = jcSupplier.get();
            genericXMLConfigurator.getRuleStore().addPathPathMapping("included", "configuration");
            Model modelFromIncludedFile = genericXMLConfigurator.buildModelFromSaxEventList(recorder.getSaxEventList());
            if (modelFromIncludedFile == null) {
                this.addError("Could not find valid configuration instructions. Exiting.");
                return;
            }
            includeModel.getSubModels().addAll(modelFromIncludedFile.getSubModels());
        }
        catch (JoranException e) {
            this.inError = true;
            this.addError("Error processing XML data in [" + this.attributeInUse + "]", e);
        }
    }

    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) throws JoranException {
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        recorder.recordEvents(inputStream);
        return recorder;
    }

    private void trimHeadAndTail(List<SaxEvent> saxEventList) {
        SaxEvent last;
        if (saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase("included")) {
            saxEventList.remove(0);
        }
        if ((last = saxEventList.get(saxEventList.size() - 1)) != null && last.qName.equalsIgnoreCase("included")) {
            saxEventList.remove(saxEventList.size() - 1);
        }
    }

    InputStream getInputStream(ModelInterpretationContext mic, IncludeModel includeModel) {
        URL inputURL = this.getInputURL(mic, includeModel);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL);
        return this.openURL(inputURL);
    }

    InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            this.optionalWarning("Failed to open [" + url.toString() + "]");
            return null;
        }
    }

    private boolean checkAttributes(IncludeModel includeModel) {
        String fileAttribute = includeModel.getFile();
        String urlAttribute = includeModel.getUrl();
        String resourceAttribute = includeModel.getResource();
        int count = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(fileAttribute)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(urlAttribute)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(resourceAttribute)) {
            ++count;
        }
        if (count == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    URL getInputURL(ModelInterpretationContext mic, IncludeModel includeModel) {
        String fileAttribute = includeModel.getFile();
        String urlAttribute = includeModel.getUrl();
        String resourceAttribute = includeModel.getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(fileAttribute)) {
            this.attributeInUse = mic.subst(fileAttribute);
            return this.filePathAsURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(urlAttribute)) {
            this.attributeInUse = mic.subst(urlAttribute);
            return this.attributeToURL(this.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(resourceAttribute)) {
            this.attributeInUse = mic.subst(resourceAttribute);
            return this.resourceAsURL(this.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    URL filePathAsURL(String path) {
        URI uri = new File(path).toURI();
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    URL attributeToURL(String urlAttribute) {
        try {
            return new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError(errMsg, mue);
            return null;
        }
    }

    URL resourceAsURL(String resourceAttribute) {
        URL url = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url == null) {
            this.optionalWarning("Could not find resource corresponding to [" + resourceAttribute + "]");
            return null;
        }
        return url;
    }

    private void optionalWarning(String msg) {
        if (!this.optional) {
            this.addWarn(msg);
        }
    }
}

