/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.core.rolling.helper;

import host.plas.bou.libs.logback.core.rolling.RolloverFailure;
import host.plas.bou.libs.logback.core.rolling.helper.CompressionMode;
import host.plas.bou.libs.logback.core.spi.ContextAwareBase;
import host.plas.bou.libs.logback.core.status.ErrorStatus;
import host.plas.bou.libs.logback.core.status.WarnStatus;
import host.plas.bou.libs.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;
    static final int BUFFER_SIZE = 8192;

    public Compressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(nameOfFile2Compress, nameOfCompressedFile);
                break;
            }
            case ZIP: {
                this.zipCompress(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
                break;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile, String innerEntryName) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (innerEntryName == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!((String)nameOfZippedFile).endsWith(".zip")) {
            nameOfZippedFile = (String)nameOfZippedFile + ".zip";
        }
        if ((zippedFile = new File((String)nameOfZippedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + (String)nameOfZippedFile + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + String.valueOf(file2zip) + "] as [" + String.valueOf(zippedFile) + "]");
        this.createMissingTargetDirsIfNecessary(zippedFile);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(nameOfFile2zip));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream((String)nameOfZippedFile));){
            int n;
            ZipEntry zipEntry = this.computeZipEntry(innerEntryName);
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1) {
                zos.write(inbuf, 0, n);
            }
            this.addInfo("Done ZIP compressing [" + String.valueOf(file2zip) + "] as [" + String.valueOf(zippedFile) + "]");
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2zip + "] into [" + (String)nameOfZippedFile + "].", this, e));
        }
        if (!file2zip.delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2zip + "].", this));
        }
    }

    ZipEntry computeZipEntry(File zippedFile) {
        return this.computeZipEntry(zippedFile.getName());
    }

    ZipEntry computeZipEntry(String filename) {
        String nameOfFileNestedWithinArchive = Compressor.computeFileNameStrWithoutCompSuffix(filename, this.compressionMode);
        return new ZipEntry(nameOfFileNestedWithinArchive);
    }

    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!((String)nameOfgzedFile).endsWith(".gz")) {
            nameOfgzedFile = (String)nameOfgzedFile + ".gz";
        }
        if ((gzedFile = new File((String)nameOfgzedFile)).exists()) {
            this.addWarn("The target compressed file named [" + (String)nameOfgzedFile + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + String.valueOf(file2gz) + "] as [" + String.valueOf(gzedFile) + "]");
        this.createMissingTargetDirsIfNecessary(gzedFile);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(nameOfFile2gz));
             GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream((String)nameOfgzedFile));){
            int n;
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1) {
                gzos.write(inbuf, 0, n);
            }
            this.addInfo("Done GZ compressing [" + String.valueOf(file2gz) + "] as [" + String.valueOf(gzedFile) + "]");
        }
        catch (Exception e) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2gz + "] into [" + (String)nameOfgzedFile + "].", this, e));
        }
        if (!file2gz.delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + nameOfFile2gz + "].", this));
        }
    }

    public static String computeFileNameStrWithoutCompSuffix(String fileNamePatternStr, CompressionMode compressionMode) {
        int len = fileNamePatternStr.length();
        switch (compressionMode) {
            case GZ: {
                if (fileNamePatternStr.endsWith(".gz")) {
                    return fileNamePatternStr.substring(0, len - 3);
                }
                return fileNamePatternStr;
            }
            case ZIP: {
                if (fileNamePatternStr.endsWith(".zip")) {
                    return fileNamePatternStr.substring(0, len - 4);
                }
                return fileNamePatternStr;
            }
            case NONE: {
                return fileNamePatternStr;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    void createMissingTargetDirsIfNecessary(File file) {
        boolean result = FileUtil.createMissingParentDirectories(file);
        if (!result) {
            this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Future<?> asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        CompressionRunnable runnable = new CompressionRunnable(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
        ExecutorService executorService = this.context.getExecutorService();
        Future<?> future = executorService.submit(runnable);
        return future;
    }

    class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;

        public CompressionRunnable(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
            this.nameOfFile2Compress = nameOfFile2Compress;
            this.nameOfCompressedFile = nameOfCompressedFile;
            this.innerEntryName = innerEntryName;
        }

        @Override
        public void run() {
            Compressor.this.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

