/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.listeners;

import gg.drak.thebase.async.AsyncUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Optional;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineBungee;
import net.streamline.platform.Messenger;
import net.streamline.platform.events.ProperEvent;
import net.streamline.platform.savables.UserManager;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.configs.given.whitelist.WhitelistConfig;
import singularity.configs.given.whitelist.WhitelistEntry;
import singularity.data.players.CosmicPlayer;
import singularity.data.uuid.UuidManager;
import singularity.events.server.CosmicChatEvent;
import singularity.events.server.KickedFromServerEvent;
import singularity.events.server.LoginCompletedEvent;
import singularity.events.server.LoginReceivedEvent;
import singularity.events.server.LogoutEvent;
import singularity.events.server.ping.PingReceivedEvent;
import singularity.messages.builders.ServerNameMessageBuilder;
import singularity.messages.events.ProxyMessageInEvent;
import singularity.messages.proxied.ProxiedMessage;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.objects.CosmicFavicon;
import singularity.objects.PingedResponse;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class PlatformListener
implements Listener {
    public PlatformListener() {
        MessageUtils.logInfo("BaseListener registered!");
    }

    @EventHandler
    public void onPreJoin(PreLoginEvent event) {
        WhitelistEntry entry;
        String uuid;
        PendingConnection connection = event.getConnection();
        if (connection == null) {
            return;
        }
        String name = connection.getName();
        Optional<String> optional = UuidManager.getUuidFromName(name);
        if (optional.isEmpty()) {
            ProxiedPlayer proxiedPlayer = ProxyServer.getInstance().getPlayer(name);
            if (proxiedPlayer == null) {
                return;
            }
            uuid = proxiedPlayer.getUniqueId().toString();
        } else {
            uuid = optional.get();
        }
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(uuid).orElse(null);
        if (streamPlayer == null) {
            return;
        }
        streamPlayer.setCurrentName(name);
        WhitelistConfig whitelistConfig = GivenConfigs.getWhitelistConfig();
        if (whitelistConfig.isEnabled() && (entry = whitelistConfig.getEntry(streamPlayer.getUuid())) == null) {
            event.setCancelReason(Messenger.getInstance().codedText(MainMessagesHandler.MESSAGES.INVALID.WHITELIST_NOT.get()));
            event.setCancelled(true);
            return;
        }
        LoginReceivedEvent loginReceivedEvent = new LoginReceivedEvent(streamPlayer);
        ModuleUtils.fireEvent(loginReceivedEvent);
        if (loginReceivedEvent.getResult().isCancelled()) {
            if (!loginReceivedEvent.getResult().validate()) {
                return;
            }
            event.setCancelReason(Messenger.getInstance().codedText(loginReceivedEvent.getResult().getDisconnectMessage()));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onJoin(PostLoginEvent event) {
        ProxiedPlayer player = event.getPlayer();
        UuidManager.cachePlayer(player.getUniqueId().toString(), player.getName(), UserManager.getInstance().parsePlayerIP(player));
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        streamPlayer.setCurrentIp(UserManager.getInstance().parsePlayerIP(player));
        streamPlayer.setCurrentName(player.getName());
        Server server = player.getServer();
        if (server != null) {
            String serverName = server.getInfo().getName();
            streamPlayer.setServerName(serverName);
            if (GivenConfigs.getServerConfig().isAutoCorrect()) {
                AsyncUtils.runAsync(() -> ServerNameMessageBuilder.build(streamPlayer, serverName).send(), 20L);
            }
        }
        LoginCompletedEvent loginCompletedEvent = new LoginCompletedEvent(streamPlayer);
        ModuleUtils.fireEvent(loginCompletedEvent);
    }

    @EventHandler
    public void onLeave(PlayerDisconnectEvent event) {
        ProxiedPlayer player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ") on disconnect.");
            return;
        }
        LogoutEvent logoutEvent = new LogoutEvent(streamPlayer);
        ModuleUtils.fireEvent(logoutEvent);
        streamPlayer.save();
        UserUtils.unloadSender(streamPlayer);
    }

    @EventHandler
    public void onServerSwitch(ServerConnectedEvent event) {
        ProxiedPlayer player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ") on server switch.");
            return;
        }
        String serverName = event.getServer().getInfo().getName();
        streamPlayer.setServerName(serverName);
        if (GivenConfigs.getServerConfig().isAutoCorrect()) {
            AsyncUtils.runAsync(() -> ServerNameMessageBuilder.build(streamPlayer, serverName).send(), 20L);
        }
    }

    @EventHandler
    public void onChat(ChatEvent event) {
        ProxiedPlayer player = (ProxiedPlayer)event.getSender();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ") on chat event.");
            return;
        }
        CosmicChatEvent chatEvent = new CosmicChatEvent(streamPlayer, event.getMessage());
        StreamlineBungee.getInstance().fireEvent(chatEvent, true);
        if (chatEvent.isCanceled()) {
            event.setCancelled(true);
            return;
        }
        event.setMessage(chatEvent.getMessage());
    }

    @EventHandler
    public void onProperEvent(ProperEvent event) {
        ModuleManager.fireEvent(event.getCosmicEvent());
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent event) {
        if (!(event.getReceiver() instanceof ProxiedPlayer)) {
            return;
        }
        ProxiedPlayer player = (ProxiedPlayer)event.getReceiver();
        String tag = event.getTag();
        if (event.getData() == null) {
            return;
        }
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ") on plugin message event.");
            return;
        }
        try {
            ProxiedMessage messageIn = new ProxiedMessage(streamPlayer, false, event.getData(), tag);
            ProxyMessageInEvent e = (ProxyMessageInEvent)new ProxyMessageInEvent(messageIn).fire();
            if (e.isCancelled()) {
                return;
            }
            SLAPI.getInstance().getProxyMessenger().receiveMessage(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler
    public void onPing(ProxyPingEvent event) {
        PingedResponse response;
        String hostName;
        ServerPing ping2 = event.getResponse();
        try {
            hostName = event.getConnection().getVirtualHost().getHostString();
        }
        catch (Throwable e) {
            hostName = "";
        }
        PingedResponse.Protocol protocol = new PingedResponse.Protocol(ping2.getVersion().getName(), ping2.getVersion().getProtocol());
        ArrayList<PingedResponse.PlayerInfo> infos = new ArrayList<PingedResponse.PlayerInfo>();
        if (ping2.getPlayers() != null && ping2.getPlayers().getSample() != null) {
            for (ServerPing.PlayerInfo info2 : ping2.getPlayers().getSample()) {
                infos.add(new PingedResponse.PlayerInfo(info2.getName(), info2.getId()));
            }
        }
        PingedResponse.Players players = new PingedResponse.Players(ping2.getPlayers().getMax(), ping2.getPlayers().getOnline(), infos.toArray(new PingedResponse.PlayerInfo[0]));
        try {
            response = ping2.getFaviconObject() != null ? new PingedResponse(protocol, players, ping2.getDescriptionComponent().toLegacyText(), ping2.getFaviconObject().getEncoded()) : new PingedResponse(protocol, players, ping2.getDescriptionComponent().toLegacyText());
        }
        catch (Throwable e) {
            MessageUtils.logWarning("Failed to get favicon from ping response: " + e.getMessage());
            MessageUtils.logWarning(e.getStackTrace());
            return;
        }
        PingReceivedEvent pingReceivedEvent = (PingReceivedEvent)new PingReceivedEvent(response, hostName).fire();
        if (pingReceivedEvent.isCancelled()) {
            return;
        }
        if (pingReceivedEvent.getResponse().getVersion().getProtocol() != -1) {
            ServerPing.Protocol protocolServer = new ServerPing.Protocol(pingReceivedEvent.getResponse().getVersion().getName(), pingReceivedEvent.getResponse().getVersion().getProtocol());
            ping2.setVersion(protocolServer);
        }
        ServerPing.PlayerInfo[] infosServer = new ServerPing.PlayerInfo[pingReceivedEvent.getResponse().getPlayers().getSample().length];
        for (int i2 = 0; i2 < pingReceivedEvent.getResponse().getPlayers().getSample().length; ++i2) {
            PingedResponse.PlayerInfo info3 = pingReceivedEvent.getResponse().getPlayers().getSample()[i2];
            infosServer[i2] = new ServerPing.PlayerInfo(info3.getName(), info3.getId());
        }
        ServerPing.Players playersServer = new ServerPing.Players(pingReceivedEvent.getResponse().getPlayers().getMax(), pingReceivedEvent.getResponse().getPlayers().getOnline(), infosServer);
        ping2.setPlayers(playersServer);
        ping2.setDescriptionComponent((BaseComponent)new TextComponent(Messenger.getInstance().codedText(pingReceivedEvent.getResponse().getDescription())));
        try {
            CosmicFavicon favicon = pingReceivedEvent.getResponse().getFavicon();
            if (favicon != null) {
                Favicon fav = Favicon.create((BufferedImage)favicon.getImage());
                ping2.setFavicon(fav);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.setResponse(ping2);
    }

    @EventHandler
    public void onServerKick(ServerKickEvent event) {
        ProxiedPlayer player = event.getPlayer();
        ServerInfo from = event.getKickedFrom();
        String kickedReason = event.getKickReason();
        String fromName = from == null ? "none" : from.getName();
        String toName = player.getServer() != null ? player.getServer().getInfo().getName() : "none";
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ") on server kick event.");
            return;
        }
        KickedFromServerEvent kickedFromServerEvent = new KickedFromServerEvent(streamPlayer, fromName, kickedReason, toName);
        ModuleUtils.fireEvent(kickedFromServerEvent);
        if (kickedFromServerEvent.isCancelled()) {
            MessageUtils.logDebug("Server " + fromName + " kicked " + player.getName() + " for " + kickedReason + " but the event was cancelled.");
            return;
        }
        event.setKickReason(kickedFromServerEvent.getReason());
        if (kickedFromServerEvent.getToServer() != null) {
            if (!kickedFromServerEvent.getToServer().equalsIgnoreCase("none")) {
                ServerInfo serverInfo = ProxyServer.getInstance().getServerInfo(kickedFromServerEvent.getToServer());
                if (serverInfo != null) {
                    event.setCancelled(true);
                    event.setCancelServer(serverInfo);
                    MessageUtils.logDebug("Server " + fromName + " kicked " + player.getName() + " for " + kickedReason + " and sent them to " + kickedFromServerEvent.getToServer());
                } else {
                    MessageUtils.logDebug("Server " + fromName + " kicked " + player.getName() + " for " + kickedReason + " but the server " + kickedFromServerEvent.getToServer() + " was not found.");
                }
            } else {
                MessageUtils.logDebug("Server " + fromName + " kicked " + player.getName() + " for " + kickedReason + " but no server was specified to send them to.");
            }
        }
    }
}

