/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.savables;

import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.streamline.api.permissions.LuckPermsHandler;
import net.streamline.platform.Messenger;
import singularity.interfaces.audiences.IPlayerInterface;
import singularity.interfaces.audiences.getters.PlayerGetter;
import singularity.interfaces.audiences.real.RealPlayer;

public class PlayerInterface
implements IPlayerInterface<ProxiedPlayer> {
    @Override
    public PlayerGetter<ProxiedPlayer> getPlayerGetter(UUID uuid) {
        return () -> ProxyServer.getInstance().getPlayer(uuid);
    }

    @Override
    public PlayerGetter<ProxiedPlayer> getPlayerGetter(String playerName) {
        return () -> ProxyServer.getInstance().getPlayer(playerName);
    }

    @Override
    public RealPlayer<ProxiedPlayer> getPlayer(PlayerGetter<ProxiedPlayer> playerGetter) {
        return new RealPlayer<ProxiedPlayer>(playerGetter){

            @Override
            public void chatAs(String command) {
                ((ProxiedPlayer)this.getPlayer()).chat(command);
            }

            @Override
            public void runCommand(String command) {
                ProxyServer.getInstance().getPluginManager().dispatchCommand((CommandSender)this.getPlayer(), command);
            }

            @Override
            public void sendMessage(String message) {
                ((ProxiedPlayer)this.getPlayer()).sendMessage(Messenger.getInstance().codedText(message));
            }

            @Override
            public void sendMessageRaw(String message) {
                ((ProxiedPlayer)this.getPlayer()).sendMessage((BaseComponent)new TextComponent(message));
            }

            @Override
            public boolean hasPermission(String permission) {
                return ((ProxiedPlayer)this.getPlayer()).hasPermission(permission);
            }

            @Override
            public void addPermission(String permission) {
                LuckPermsHandler.addPermission(((ProxiedPlayer)this.getPlayer()).getUniqueId().toString(), permission);
            }

            @Override
            public void removePermission(String permission) {
                LuckPermsHandler.removePermission(((ProxiedPlayer)this.getPlayer()).getUniqueId().toString(), permission);
            }
        };
    }
}

