/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.savables;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.streamline.api.SLAPI;
import net.streamline.api.permissions.LuckPermsHandler;
import net.streamline.base.StreamlineBungee;
import net.streamline.platform.BasePlugin;
import net.streamline.platform.Messenger;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.CosmicLocation;
import singularity.data.server.CosmicServer;
import singularity.interfaces.IUserManager;
import singularity.messages.builders.ResourcePackMessageBuilder;
import singularity.objects.CosmicResourcePack;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class UserManager
implements IUserManager<CommandSender, ProxiedPlayer> {
    private static UserManager instance;

    public UserManager() {
        instance = this;
    }

    @Override
    public Optional<CosmicPlayer> getOrCreatePlayer(ProxiedPlayer player) {
        return UserUtils.getOrCreatePlayer(player.getUniqueId().toString());
    }

    @Override
    public Optional<CosmicSender> getOrCreateSender(CommandSender sender) {
        if (this.isConsole(sender)) {
            return Optional.ofNullable(UserUtils.getConsole());
        }
        ProxiedPlayer player = (ProxiedPlayer)sender;
        return this.getOrCreatePlayer(player).map(s2 -> s2);
    }

    public String getUsername(CommandSender sender) {
        if (this.isConsole(sender)) {
            return GivenConfigs.getMainConfig().getConsoleName();
        }
        return sender.getName();
    }

    @Override
    public String getUsername(String uuid) {
        if (uuid.equals(GivenConfigs.getMainConfig().getConsoleDiscriminator())) {
            return GivenConfigs.getMainConfig().getConsoleName();
        }
        ProxiedPlayer player = StreamlineBungee.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return this.getUsername((CommandSender)player);
    }

    public boolean isConsole(CommandSender sender) {
        return !(sender instanceof ProxiedPlayer);
    }

    @Override
    public boolean isOnline(String uuid) {
        if (UserUtils.isConsole(uuid)) {
            return true;
        }
        for (ProxiedPlayer player : BasePlugin.onlinePlayers()) {
            if (!player.getUniqueId().toString().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public String parsePlayerIP(ProxiedPlayer player) {
        if (player == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        SocketAddress address = player.getSocketAddress();
        if (address == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_NULL.get();
        }
        String ipSt = address.toString().replace("/", "");
        String[] ipSplit = ipSt.split(":");
        ipSt = ipSplit[0];
        return ipSt;
    }

    @Override
    public boolean runAs(CosmicSender user, boolean bypass, String command) {
        if (!(user instanceof CosmicPlayer)) {
            CommandSender source = StreamlineBungee.getInstance().getProxy().getConsole();
            StreamlineBungee.getInstance().getProxy().getPluginManager().dispatchCommand(source, command);
            return true;
        }
        CosmicPlayer player = (CosmicPlayer)user;
        ProxiedPlayer source = StreamlineBungee.getPlayer(player.getUuid());
        player = (CosmicPlayer)user;
        if (source == null) {
            return false;
        }
        boolean already = source.hasPermission("*");
        if (bypass && !already) {
            if (LuckPermsHandler.hasLuckPerms()) {
                LuckPermsHandler.addPermission(player.getUuid(), "*");
            } else {
                return false;
            }
        }
        StreamlineBungee.getInstance().getProxy().getPluginManager().dispatchCommand((CommandSender)source, command);
        if (bypass && !already) {
            if (LuckPermsHandler.hasLuckPerms()) {
                LuckPermsHandler.removePermission(player.getUuid(), "*");
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public ConcurrentSkipListSet<CosmicPlayer> getUsersOn(String server) {
        ConcurrentSkipListSet<CosmicPlayer> r = new ConcurrentSkipListSet<CosmicPlayer>();
        StreamlineBungee.getInstance().getProxy().getServers().values().forEach(a -> a.getPlayers().forEach(b -> {
            CosmicPlayer player = this.getOrCreatePlayer((ProxiedPlayer)b).orElse(null);
            if (player == null) {
                return;
            }
            if (player.isOnline() && player.getServerName().equals(server)) {
                r.add(player);
            }
        }));
        return r;
    }

    @Override
    public void connect(CosmicPlayer user, String server) {
        if (!user.isOnline()) {
            return;
        }
        ProxiedPlayer player = StreamlineBungee.getPlayer(user.getUuid());
        if (player == null) {
            return;
        }
        ServerInfo serverInfo = StreamlineBungee.getInstance().getProxy().getServerInfo(server);
        if (serverInfo == null) {
            MessageUtils.logWarning("Tried to send a user with uuid of '" + user.getUuid() + "' to server '" + server + "', but it does not exist!");
            return;
        }
        player.connect(serverInfo, ServerConnectEvent.Reason.PLUGIN);
    }

    @Override
    public void sendUserResourcePack(CosmicPlayer user, CosmicResourcePack pack) {
        if (!user.isOnline()) {
            return;
        }
        ProxiedPlayer p = StreamlineBungee.getPlayer(user.getUuid());
        if (p == null) {
            return;
        }
        SLAPI.getInstance().getProxyMessenger().sendMessage(ResourcePackMessageBuilder.build(user, true, user, pack));
    }

    @Override
    public String parsePlayerIP(String uuid) {
        ProxiedPlayer player = StreamlineBungee.getPlayer(uuid);
        if (player == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.IS_NULL.get();
        }
        InetSocketAddress address = (InetSocketAddress)player.getSocketAddress();
        if (address == null) {
            return MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_NULL.get();
        }
        String ipSt = address.toString().replace("/", "");
        String[] ipSplit = ipSt.split(":");
        ipSt = ipSplit[0];
        return ipSt;
    }

    @Override
    public double getPlayerPing(String uuid) {
        ProxiedPlayer player = StreamlineBungee.getPlayer(uuid);
        if (player == null) {
            return 0.0;
        }
        return player.getPing();
    }

    @Override
    public void kick(CosmicPlayer user, String message) {
        ProxiedPlayer player = StreamlineBungee.getInstance().getProxy().getPlayer(user.getUuid());
        if (player == null) {
            return;
        }
        player.disconnect(Messenger.getInstance().codedText(message));
    }

    @Override
    public ProxiedPlayer getPlayer(String uuid) {
        return StreamlineBungee.getPlayer(uuid);
    }

    @Override
    public ConcurrentSkipListMap<String, CosmicPlayer> ensurePlayers() {
        ConcurrentSkipListMap<String, CosmicPlayer> r = new ConcurrentSkipListMap<String, CosmicPlayer>();
        for (ProxiedPlayer player : BasePlugin.onlinePlayers()) {
            CosmicPlayer cosmicPlayer;
            if (!UserUtils.isLoaded(player.getUniqueId().toString()) || (cosmicPlayer = (CosmicPlayer)this.getOrCreatePlayer(player).orElse(null)) == null) continue;
            r.put(player.getUniqueId().toString(), cosmicPlayer);
        }
        return r;
    }

    @Override
    public String getServerPlayerIsOn(String uuid) {
        ProxiedPlayer player = this.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        Server server = player.getServer();
        if (server == null) {
            return null;
        }
        ServerInfo info2 = server.getInfo();
        if (info2 == null) {
            return null;
        }
        return info2.getName();
    }

    @Override
    public String getServerPlayerIsOn(ProxiedPlayer player) {
        return this.getServerPlayerIsOn(player.getUniqueId().toString());
    }

    @Override
    public String getDisplayName(String uuid) {
        ProxiedPlayer player = this.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return player.getDisplayName();
    }

    @Override
    public void teleport(CosmicPlayer player, CosmicLocation location) {
        if (!player.isOnline()) {
            return;
        }
        ProxiedPlayer p = StreamlineBungee.getPlayer(player.getUuid());
        if (p == null) {
            return;
        }
        CosmicServer server = location.getServer();
        String serverName = server.getIdentifier();
        ServerInfo info2 = StreamlineBungee.getInstance().getProxy().getServerInfo(serverName);
        if (info2 == null) {
            return;
        }
        p.connect(info2, ServerConnectEvent.Reason.PLUGIN);
    }

    public static UserManager getInstance() {
        return instance;
    }
}

