/*
 * Decompiled with CFR 0.152.
 */
package singularity;

import gg.drak.thebase.async.AsyncUtils;
import gg.drak.thebase.objects.SingleSet;
import gg.drak.thebase.objects.handling.derived.PluginEventable;
import host.plas.bou.libs.logback.classic.Logger;
import host.plas.bou.libs.logback.classic.LoggerContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;
import singularity.configs.given.GivenConfigs;
import singularity.data.console.CosmicSender;
import singularity.data.runners.PlayerSaver;
import singularity.data.update.defaults.DefaultUpdaters;
import singularity.data.uuid.UuidInfo;
import singularity.data.uuid.UuidManager;
import singularity.database.CoreDBOperator;
import singularity.database.servers.SavedServer;
import singularity.interfaces.IBackendHandler;
import singularity.interfaces.IMessenger;
import singularity.interfaces.ISingularityExtension;
import singularity.interfaces.IUserManager;
import singularity.interfaces.audiences.IConsoleHolder;
import singularity.interfaces.audiences.IPlayerInterface;
import singularity.interfaces.audiences.real.RealPlayer;
import singularity.interfaces.audiences.real.RealSender;
import singularity.logging.CosmicLogHandler;
import singularity.logging.CosmicLogbackAppender;
import singularity.logging.LogCollector;
import singularity.messages.ProxyMessenger;
import singularity.messages.proxied.ProxiedMessageManager;
import singularity.modules.CosmicModule;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.scheduler.BaseRunnable;
import singularity.scheduler.ModuleTaskManager;
import singularity.timers.TPTicketFlusher;
import singularity.timers.TPTicketPuller;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class Singularity<C, P extends C, S extends ISingularityExtension, U extends IUserManager<C, P>, M extends IMessenger>
extends PluginEventable {
    private static CommandRunner commandRunner;
    private static LinkedHashMap<Integer, SingleSet<String, CosmicSender>> cachedCommands;
    private static File moduleFolder;
    private static File moduleSaveFolder;
    private static File mainCommandsFolder;
    private static final String commandsFolderChild;
    private static Singularity<?, ?, ?, ?, ?> instance;
    private final S platform;
    private final U userManager;
    private final M messenger;
    private final IConsoleHolder<C> consoleHolder;
    private final IPlayerInterface<P> playerInterface;
    private ProxyMessenger proxyMessenger;
    private static CosmicModule baseModule;
    private static ModuleTaskManager moduleScheduler;
    private static IBackendHandler backendHandler;
    private static boolean proxiedServer;
    private static boolean proxy;
    private static TPTicketFlusher tpTicketFlusher;
    private static TPTicketPuller tpTicketPuller;
    private static boolean ready;
    private static String apiChannel;
    private static PlayerSaver playerSaver;
    private static AtomicBoolean databaseReady;
    private static AtomicBoolean platformEnabled;

    public static void addCachedCommand(String command, CosmicSender user) {
        int lastId = Singularity.getCachedCommands().keySet().stream().max(Integer::compareTo).orElse(0);
        Singularity.getCachedCommands().put(lastId + 1, new SingleSet<String, CosmicSender>(command, user));
    }

    public static void removeCachedCommand(int id) {
        cachedCommands.remove(id);
    }

    public static CoreDBOperator getMainDatabase() {
        return GivenConfigs.getMainDatabase();
    }

    public static void setMainDatabase(CoreDBOperator mainDatabase) {
        GivenConfigs.setMainDatabase(mainDatabase);
    }

    public Singularity(String identifier, S platform, U userManager, M messenger, IConsoleHolder<C> consoleHolder, IPlayerInterface<P> playerInterface, Supplier<CosmicModule> baseModuleGetter, String apiChannel) {
        super(identifier);
        instance = this;
        databaseReady = new AtomicBoolean(false);
        platformEnabled = new AtomicBoolean(false);
        this.platform = platform;
        this.userManager = userManager;
        this.messenger = messenger;
        this.consoleHolder = consoleHolder;
        this.playerInterface = playerInterface;
        this.setupLogger();
        Singularity.setApiChannel(apiChannel);
        Singularity.setProxy(platform.getServerType().equals((Object)ISingularityExtension.ServerType.PROXY));
        moduleFolder = new File(this.getDataFolder(), "modules" + File.separator);
        moduleSaveFolder = new File(this.getDataFolder(), "module-resources" + File.separator);
        mainCommandsFolder = new File(this.getDataFolder(), Singularity.getCommandsFolderChild());
        moduleFolder.mkdirs();
        moduleSaveFolder.mkdirs();
        mainCommandsFolder.mkdirs();
        GivenConfigs.init();
        AsyncUtils.executeAsync(this::initDatabase);
        AsyncUtils.executeAsync(() -> this.initModules(baseModuleGetter));
        ProxiedMessageManager.init();
        Singularity.setCommandRunner(new CommandRunner());
        MessageUtils.init();
        DefaultUpdaters.init();
        playerSaver = new PlayerSaver();
        LogCollector.init();
        tpTicketFlusher = new TPTicketFlusher();
        tpTicketPuller = new TPTicketPuller();
        Singularity.setReady(true);
    }

    public Singularity(String identifier, S platform, U userManager, M messenger, IConsoleHolder<C> consoleHolder, IPlayerInterface<P> playerInterface, String apiChannel) {
        this(identifier, platform, userManager, messenger, consoleHolder, playerInterface, null, apiChannel);
    }

    public static boolean isPlatformEnabled() {
        return platformEnabled != null && platformEnabled.get();
    }

    public static void platformEnabled(boolean platformEnabled) {
        if (Singularity.platformEnabled == null) {
            Singularity.platformEnabled = new AtomicBoolean(false);
        }
        Singularity.platformEnabled.set(platformEnabled);
    }

    public void initDatabase() {
        GivenConfigs.awaitDatabaseReady();
        try {
            Singularity.getMainDatabase().ensureUsable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ConcurrentSkipListSet<UuidInfo> uuidInfos = Singularity.getMainDatabase().pullAllUuidInfo().join();
            UuidManager.registerAll(uuidInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserUtils.loadConsole();
        databaseReady.set(true);
    }

    public void initModules(Supplier<CosmicModule> baseModuleGetter) {
        Singularity.awaitDatabaseReady();
        moduleScheduler = new ModuleTaskManager();
        if (baseModuleGetter != null) {
            Singularity.setBaseModule(baseModuleGetter.get());
        }
        this.getFiles(Singularity.getModuleFolder(), file -> {
            if (file.isDirectory()) {
                return true;
            }
            return !file.getName().endsWith(".jar");
        }).forEach((s2, file) -> {
            try {
                Files.move(file.toPath(), Path.of(file.toPath().toString().replace(Singularity.getModuleFolder().toPath().toString(), Singularity.getModuleSaveFolder().toPath().toString()), new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try {
            this.awaitPlatformEnabled();
            ModuleManager.registerExternalModules();
            ModuleManager.startModules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void awaitPlatformEnabled() {
        if (Singularity.isPlatformEnabled()) {
            return;
        }
        while (!Singularity.isPlatformEnabled()) {
            Thread.onSpinWait();
        }
    }

    public void setupLogger() {
        try {
            if (this.getPlatform().hasLoggerLogger()) {
                java.util.logging.Logger rootLogger = this.getPlatform().getLoggerLogger();
                CosmicLogHandler handler = new CosmicLogHandler();
                rootLogger.addHandler(handler);
            }
            if (this.getPlatform().hasSLFLogger()) {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                Logger rootLogger = loggerContext.getLogger("ROOT");
                rootLogger.detachAndStopAllAppenders();
                CosmicLogbackAppender appender = new CosmicLogbackAppender();
                appender.setContext(loggerContext);
                appender.setName("CosmicLogbackAppender");
                appender.start();
                rootLogger.addAppender(appender);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isDatabaseReady() {
        return databaseReady.get();
    }

    public static void awaitDatabaseReady() {
        if (Singularity.isDatabaseReady()) {
            return;
        }
        while (!Singularity.isDatabaseReady()) {
            Thread.onSpinWait();
        }
    }

    public static String getServerUuid() {
        return GivenConfigs.getServer().getUuid();
    }

    public static String getServerName() {
        return GivenConfigs.getServer().getName();
    }

    public static SavedServer getServer() {
        return GivenConfigs.getServerConfig().getServer();
    }

    public ConcurrentSkipListMap<String, File> getFiles(File folder, Predicate<File> filePredicate) {
        ConcurrentSkipListMap<String, File> r = new ConcurrentSkipListMap<String, File>();
        if (!folder.isDirectory()) {
            return r;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return r;
        }
        for (File file : files) {
            if (!filePredicate.test(file)) continue;
            r.put(file.getName(), file);
        }
        return r;
    }

    public InputStream getResourceAsStream(String filename) {
        return this.getClass().getClassLoader().getResourceAsStream(filename);
    }

    public InputStream getResourceAsStreamMain(String filename) {
        return this.getPlatform().getMainClassLoader().getResourceAsStream(filename);
    }

    public static File getMainFolder() {
        return Singularity.getInstance().getDataFolder();
    }

    public static <C> RealSender<C> getConsole() {
        return Singularity.getInstance().getConsoleHolder().getRealConsole();
    }

    public static <P> RealPlayer<P> getPlayer(UUID uuid) {
        return Singularity.getInstance().getPlayerInterface().getPlayer(uuid);
    }

    public static <P> RealPlayer<P> getPlayer(String name) {
        return Singularity.getInstance().getPlayerInterface().getPlayer(name);
    }

    public static <P> RealPlayer<P> getPlayerFromUuid(String uuid) {
        return Singularity.getInstance().getPlayerInterface().getPlayer(UUID.fromString(uuid));
    }

    public static void sendConsoleMessage(String message) {
        Singularity.getInstance().getConsoleHolder().sendConsoleMessage(message);
    }

    public static boolean isOfflineMode() {
        return Singularity.getInstance().getPlatform().isOfflineMode();
    }

    public static CommandRunner getCommandRunner() {
        return commandRunner;
    }

    public static void setCommandRunner(CommandRunner commandRunner) {
        Singularity.commandRunner = commandRunner;
    }

    public static LinkedHashMap<Integer, SingleSet<String, CosmicSender>> getCachedCommands() {
        return cachedCommands;
    }

    public static void setCachedCommands(LinkedHashMap<Integer, SingleSet<String, CosmicSender>> cachedCommands) {
        Singularity.cachedCommands = cachedCommands;
    }

    public static File getModuleFolder() {
        return moduleFolder;
    }

    public static File getModuleSaveFolder() {
        return moduleSaveFolder;
    }

    public static File getMainCommandsFolder() {
        return mainCommandsFolder;
    }

    public static String getCommandsFolderChild() {
        return commandsFolderChild;
    }

    public static Singularity<?, ?, ?, ?, ?> getInstance() {
        return instance;
    }

    public S getPlatform() {
        return this.platform;
    }

    public U getUserManager() {
        return this.userManager;
    }

    public M getMessenger() {
        return this.messenger;
    }

    public IConsoleHolder<C> getConsoleHolder() {
        return this.consoleHolder;
    }

    public IPlayerInterface<P> getPlayerInterface() {
        return this.playerInterface;
    }

    public ProxyMessenger getProxyMessenger() {
        return this.proxyMessenger;
    }

    public void setProxyMessenger(ProxyMessenger proxyMessenger) {
        this.proxyMessenger = proxyMessenger;
    }

    public static CosmicModule getBaseModule() {
        return baseModule;
    }

    public static void setBaseModule(CosmicModule baseModule) {
        Singularity.baseModule = baseModule;
    }

    public static ModuleTaskManager getModuleScheduler() {
        return moduleScheduler;
    }

    public static IBackendHandler getBackendHandler() {
        return backendHandler;
    }

    public static void setBackendHandler(IBackendHandler backendHandler) {
        Singularity.backendHandler = backendHandler;
    }

    public static boolean isProxiedServer() {
        return proxiedServer;
    }

    public static void setProxiedServer(boolean proxiedServer) {
        Singularity.proxiedServer = proxiedServer;
    }

    public static boolean isProxy() {
        return proxy;
    }

    public static void setProxy(boolean proxy) {
        Singularity.proxy = proxy;
    }

    public static TPTicketFlusher getTpTicketFlusher() {
        return tpTicketFlusher;
    }

    public static void setTpTicketFlusher(TPTicketFlusher tpTicketFlusher) {
        Singularity.tpTicketFlusher = tpTicketFlusher;
    }

    public static TPTicketPuller getTpTicketPuller() {
        return tpTicketPuller;
    }

    public static void setTpTicketPuller(TPTicketPuller tpTicketPuller) {
        Singularity.tpTicketPuller = tpTicketPuller;
    }

    public static boolean isReady() {
        return ready;
    }

    public static void setReady(boolean ready) {
        Singularity.ready = ready;
    }

    public static String getApiChannel() {
        return apiChannel;
    }

    public static void setApiChannel(String apiChannel) {
        Singularity.apiChannel = apiChannel;
    }

    public static PlayerSaver getPlayerSaver() {
        return playerSaver;
    }

    public static void setPlayerSaver(PlayerSaver playerSaver) {
        Singularity.playerSaver = playerSaver;
    }

    public static AtomicBoolean getDatabaseReady() {
        return databaseReady;
    }

    public static void setDatabaseReady(AtomicBoolean databaseReady) {
        Singularity.databaseReady = databaseReady;
    }

    public static AtomicBoolean getPlatformEnabled() {
        return platformEnabled;
    }

    public static void setPlatformEnabled(AtomicBoolean platformEnabled) {
        Singularity.platformEnabled = platformEnabled;
    }

    static {
        cachedCommands = new LinkedHashMap();
        commandsFolderChild = "commands" + File.separator;
        ready = false;
    }

    public static class CommandRunner
    extends BaseRunnable {
        public CommandRunner() {
            super(0L, 1L);
        }

        @Override
        public void run() {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (int i2 : Singularity.getCachedCommands().keySet()) {
                toRemove.add(i2);
                SingleSet<String, CosmicSender> set2 = Singularity.getCachedCommands().get(i2);
                String command = set2.getKey();
                CosmicSender user = set2.getValue();
                command = ModuleUtils.replacePlaceholders(user, command);
                RunType runType = RunType.CONSOLE_COMMAND;
                if (command.startsWith("@ ")) {
                    runType = RunType.NORMAL_COMMAND;
                    command = command.substring(2);
                } else if (command.startsWith("? ")) {
                    runType = RunType.CONSOLE_COMMAND;
                    command = command.substring(3);
                } else if (command.startsWith("! ")) {
                    runType = RunType.OPERATOR_COMMAND;
                    command = command.substring(2);
                } else if (command.startsWith("# ")) {
                    runType = RunType.NORMAL_CHAT;
                    command = command.substring(2);
                }
                switch (runType.ordinal()) {
                    case 3: {
                        Singularity.getConsole().runCommand(command);
                        break;
                    }
                    case 0: {
                        if (user.isConsole()) {
                            Singularity.getConsole().runCommand(command);
                            break;
                        }
                        Singularity.getPlayerFromUuid(user.getUuid()).runCommand(command);
                        break;
                    }
                    case 2: {
                        MessageUtils.logWarning("Operator command running is not yet supported.");
                        break;
                    }
                    case 1: {
                        if (user.isConsole()) {
                            return;
                        }
                        Singularity.getPlayerFromUuid(user.getUuid()).chatAs(command);
                    }
                }
            }
            for (int i2 : toRemove) {
                Singularity.removeCachedCommand(i2);
            }
        }
    }

    public static enum RunType {
        NORMAL_COMMAND,
        NORMAL_CHAT,
        OPERATOR_COMMAND,
        CONSOLE_COMMAND;

    }
}

