/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given.punishments;

import gg.drak.thebase.objects.AtomicString;
import gg.drak.thebase.storage.datastores.SimpleJsonDatastore;
import java.util.Date;
import singularity.Singularity;
import singularity.configs.given.punishments.CosmicPunishment;
import singularity.configs.given.punishments.PunishmentType;

public class PunishmentsDocument
extends SimpleJsonDatastore<CosmicPunishment> {
    public PunishmentsDocument() {
        super("punishments.json", Singularity.getInstance(), false);
    }

    @Override
    public void init(CosmicPunishment cosmicPunishment) {
        String keyPrefix = cosmicPunishment.getPunishedUUID() + "." + cosmicPunishment.getType().name() + "." + cosmicPunishment.getIdHash() + ".";
        this.write(keyPrefix + "punisher", cosmicPunishment.getPunisherUUID());
        this.write(keyPrefix + "reason", cosmicPunishment.getReason());
        this.write(keyPrefix + "timeToUnpunish", cosmicPunishment.getTimeToUnpunish().getTime());
    }

    @Override
    public void save(CosmicPunishment cosmicPunishment) {
        String keyPrefix = cosmicPunishment.getPunishedUUID() + "." + cosmicPunishment.getType().name() + "." + cosmicPunishment.getIdHash() + ".";
        this.write(keyPrefix + "punisher", cosmicPunishment.getPunisherUUID());
        this.write(keyPrefix + "reason", cosmicPunishment.getReason());
        this.write(keyPrefix + "timeToUnpunish", cosmicPunishment.getTimeToUnpunish().getTime());
    }

    @Override
    public CosmicPunishment get(String hash) {
        String keyPrefix = this.getKeyPrefix(hash);
        if (keyPrefix == null) {
            return null;
        }
        String punisherUUID = this.get(keyPrefix + "punisher", String.class);
        String reason = this.get(keyPrefix + "reason", String.class);
        long timeToUnpunish = this.get(keyPrefix + "timeToUnpunish", Long.class);
        return new CosmicPunishment(hash, punisherUUID, reason, PunishmentType.valueOf(hash.split("\\.")[1]), new Date(timeToUnpunish));
    }

    public String getKeyPrefix(String hash) {
        AtomicString keyPrefix = new AtomicString();
        this.singleLayerKeySet().forEach(key -> this.singleLayerKeySet((String)key).forEach(key2 -> this.singleLayerKeySet(key + "." + key2).forEach(key3 -> {
            if (key3.equals(hash)) {
                keyPrefix.set(key + "." + key2 + "." + key3 + ".");
            }
        })));
        return (String)keyPrefix.get();
    }

    @Override
    public void onInit() {
    }

    @Override
    public void onSave() {
    }
}

