/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.console.CosmicSender;
import singularity.data.players.events.SaveSenderEvent;
import singularity.data.players.location.CosmicLocation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.server.CosmicServer;
import singularity.database.CoreDBOperator;
import singularity.interfaces.audiences.real.RealPlayer;
import singularity.utils.UserUtils;

public class CosmicPlayer
extends CosmicSender {
    private String currentIp;
    private CosmicLocation location;

    public CosmicPlayer(String uuid, boolean temporary) {
        super(uuid, temporary);
        this.setServerName("");
        this.currentIp = "";
        this.location = new CosmicLocation(this);
    }

    public CosmicPlayer(String uuid) {
        this(uuid, false);
    }

    public CosmicLocation getLocation() {
        if (this.location == null) {
            this.location = new CosmicLocation(this);
        }
        return this.location;
    }

    public CosmicSender setCurrentIp(String currentIP) {
        String processed = currentIP;
        if (!GivenConfigs.getMainConfig().isSpoofIPs()) {
            if (processed == null || processed.isBlank() || processed.isEmpty()) {
                processed = Singularity.getInstance().getUserManager().parsePlayerIP(this.getUuid());
            }
        } else {
            processed = GivenConfigs.getMainConfig().getSpoofedIP();
        }
        this.currentIp = processed;
        return this;
    }

    public String getCurrentIp() {
        if (!GivenConfigs.getMainConfig().isSpoofIPs()) {
            return this.currentIp;
        }
        return GivenConfigs.getMainConfig().getSpoofedIP();
    }

    @Override
    public void augmentMore(CosmicPlayer player) {
        this.setCurrentIp(player.getCurrentIp());
        this.setLocation(player.getLocation());
        this.setCurrentIpAsProper();
        this.setCurrentServerAsProper();
    }

    public void setCurrentIpAsProper() {
        this.setCurrentIp(Singularity.getInstance().getUserManager().parsePlayerIP(this.getUuid()));
    }

    public CoreDBOperator getDatabase() {
        return Singularity.getMainDatabase();
    }

    public boolean exists() {
        return UserUtils.userExists(this.getUuid());
    }

    public void ensureCorrect() {
        this.setCurrentNameAsProper();
        this.setCurrentIpAsProper();
        this.setCurrentServerAsProper();
    }

    public void setCurrentServerAsProper() {
        this.setServerName(Singularity.getInstance().getUserManager().getServerPlayerIsOn(this.getUuid()));
    }

    @Override
    public void save() {
        this.ensureCorrect();
        this.getDatabase().savePlayer(this);
        new SaveSenderEvent(this).fire();
    }

    @Override
    public boolean isOnline() {
        return Singularity.getInstance().getUserManager().isOnline(this.getUuid());
    }

    public RealPlayer<?> asReal() {
        return Singularity.getPlayerFromUuid(this.getUuid());
    }

    public PlayerWorld getWorld() {
        return this.getLocation().getWorld();
    }

    public void setWorld(PlayerWorld world) {
        this.getLocation().setWorld(world);
    }

    public String getWorldName() {
        return this.getLocation().getWorldName();
    }

    public void setWorldName(String worldName) {
        this.getLocation().setWorldName(worldName);
    }

    public double getX() {
        return this.getLocation().getX();
    }

    public void setX(double x) {
        this.getLocation().setX(x);
    }

    public double getY() {
        return this.getLocation().getY();
    }

    public void setY(double y) {
        this.getLocation().setY(y);
    }

    public double getZ() {
        return this.getLocation().getZ();
    }

    public void setZ(double z) {
        this.getLocation().setZ(z);
    }

    public float getYaw() {
        return this.getLocation().getYaw();
    }

    public void setYaw(float yaw) {
        this.getLocation().setYaw(yaw);
    }

    public float getPitch() {
        return this.getLocation().getPitch();
    }

    public void setPitch(float pitch) {
        this.getLocation().setPitch(pitch);
    }

    @Override
    public void reload() {
        CompletableFuture.runAsync(() -> {
            Optional<CosmicSender> optional = Singularity.getMainDatabase().loadPlayer(this.getUuid()).join();
            if (optional.isEmpty()) {
                return;
            }
            CosmicSender sender = optional.get();
            if (!(sender instanceof CosmicPlayer)) {
                return;
            }
            CosmicPlayer streamPlayer = (CosmicPlayer)sender;
            this.setFirstJoinMillis(streamPlayer.getFirstJoinDate().getTime());
            this.setLastJoinMillis(streamPlayer.getLastJoinDate().getTime());
            this.setLastQuitMillis(streamPlayer.getLastQuitDate().getTime());
            this.setPlaySeconds(streamPlayer.getPlaySeconds());
            this.setMeta(streamPlayer.getMeta());
            this.setPermissions(streamPlayer.getPermissions());
            this.setCurrentIp(streamPlayer.getCurrentIp());
            this.setLocation(streamPlayer.getLocation());
        });
    }

    public double getPlayMinutes() {
        return (double)this.getPlaySeconds() / 60.0;
    }

    public String getPlayMinutesAsString() {
        return String.format("%.2f", this.getPlayMinutes());
    }

    public double getPlayHours() {
        return this.getPlayMinutes() / 60.0;
    }

    public String getPlayHoursAsString() {
        return String.format("%.2f", this.getPlayHours());
    }

    public double getPlayDays() {
        return this.getPlayHours() / 24.0;
    }

    public String getPlayDaysAsString() {
        return String.format("%.2f", this.getPlayDays());
    }

    public String getPlaySecondsAsString() {
        return String.valueOf(this.getPlaySeconds());
    }

    public String getRealServer() {
        return Singularity.getInstance().getUserManager().getServerPlayerIsOn(this.getUuid());
    }

    public void setServerToRealServer() {
        this.setServerName(this.getRealServer());
    }

    @Override
    public void setServer(CosmicServer server) {
        this.getLocation().setServer(server);
    }

    @Override
    public void setServerName(String serverName) {
        this.getLocation().setServerName(serverName);
    }

    @Override
    public CosmicServer getServer() {
        return this.getLocation().getServer();
    }

    @Override
    public String getServerName() {
        return this.getLocation().getServerName();
    }

    public void setLocation(CosmicLocation location) {
        this.location = location;
    }
}

