/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.builders;

import java.util.Date;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.players.CosmicPlayer;
import singularity.messages.proxied.ProxiedMessage;
import singularity.utils.MessageUtils;

public class ServerNameMessageBuilder {
    private static String subChannel = "server-name-setter";
    private static Date lastUpdate = null;

    public static ProxiedMessage build(CosmicPlayer carrier, String serverName) {
        ProxiedMessage r = new ProxiedMessage(carrier, Singularity.isProxy());
        r.setSubChannel(ServerNameMessageBuilder.getSubChannel());
        r.write("serverName", serverName);
        return r;
    }

    public static void handle(ProxiedMessage in) {
        if (!in.getSubChannel().equals(ServerNameMessageBuilder.getSubChannel())) {
            return;
        }
        if (!ServerNameMessageBuilder.isNeedUpdate()) {
            return;
        }
        String serverName = in.getString("serverName");
        if (serverName == null) {
            MessageUtils.logWarning("Received an invalid server name update call: " + in.getLiteralAsString());
            return;
        }
        GivenConfigs.writeServerName(serverName);
        ServerNameMessageBuilder.update();
    }

    public static boolean isNeedUpdate() {
        if (ServerNameMessageBuilder.getLastUpdate() == null) {
            return true;
        }
        return new Date().getTime() - ServerNameMessageBuilder.getLastUpdate().getTime() > ServerNameMessageBuilder.getUpdateMillis();
    }

    public static void update() {
        ServerNameMessageBuilder.setLastUpdate(new Date());
    }

    public static long getUpdateMillis() {
        return 1800000L;
    }

    public static String getSubChannel() {
        return subChannel;
    }

    public static void setSubChannel(String subChannel) {
        ServerNameMessageBuilder.subChannel = subChannel;
    }

    public static Date getLastUpdate() {
        return lastUpdate;
    }

    public static void setLastUpdate(Date lastUpdate) {
        ServerNameMessageBuilder.lastUpdate = lastUpdate;
    }
}

