/*
 * Decompiled with CFR 0.152.
 */
package singularity.redis;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.api.reactive.RedisStringReactiveCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.RedisConfigHandler;
import singularity.redis.RedisMessage;
import singularity.redis.TPTicketListener;
import singularity.utils.MessageUtils;

public class OwnRedisClient {
    private static AtomicBoolean connectedAtomic = new AtomicBoolean(false);
    private static TPTicketListener tpTicketListener;
    private static RedisClient redisClient;

    public static RedisConfigHandler getConfig() {
        return GivenConfigs.getRedisConfig();
    }

    public static String getHost() {
        return OwnRedisClient.getConfig().getHost();
    }

    public static int getPort() {
        return OwnRedisClient.getConfig().getPort();
    }

    public static String getUsername() {
        return OwnRedisClient.getConfig().getUsername();
    }

    public static String getPassword() {
        return OwnRedisClient.getConfig().getPassword();
    }

    public static boolean isEnabled() {
        return OwnRedisClient.getConfig().isEnabled();
    }

    public static boolean isConnected() {
        return connectedAtomic.get();
    }

    public static void setConnected(boolean connected) {
        connectedAtomic.set(connected);
    }

    public static boolean isUserValid() {
        return OwnRedisClient.getUsername() != null && !OwnRedisClient.getUsername().isBlank() && !OwnRedisClient.getUsername().equals("null");
    }

    public static RedisClient getClient() {
        if (OwnRedisClient.getRedisClient() == null) {
            OwnRedisClient.setRedisClient(OwnRedisClient.create());
        }
        return OwnRedisClient.getRedisClient();
    }

    public static RedisClient create() {
        RedisURI.Builder builder = RedisURI.Builder.redis(OwnRedisClient.getHost(), OwnRedisClient.getPort());
        builder = OwnRedisClient.isUserValid() ? builder.withAuthentication(OwnRedisClient.getUsername(), OwnRedisClient.getPassword()) : builder.withPassword(OwnRedisClient.getPasswordChars());
        return RedisClient.create(builder.build());
    }

    public static CharSequence getPasswordChars() {
        return OwnRedisClient.getPassword();
    }

    public static void testConnection() {
        RedisClient client = OwnRedisClient.getClient();
        StatefulRedisConnection<String, String> connection = client.connect();
        if (connection.isOpen()) {
            MessageUtils.logInfo("&cRedis &fauthenticated &asuccessfully&f!");
            OwnRedisClient.setConnected(true);
            String pingResponse = connection.sync().ping();
            MessageUtils.logInfo("&cRedis &fping response: " + (Objects.equals(pingResponse, "PONG") ? "&aCONNECTED" : "&cFAILURE"));
        } else {
            MessageUtils.logInfo("&cRedis authentication &cfailed&f: &b" + OwnRedisClient.getHost() + ":" + OwnRedisClient.getPort() + "&f. Please check your configuration.");
            OwnRedisClient.setConnected(false);
        }
        if (OwnRedisClient.isConnected()) {
            tpTicketListener = new TPTicketListener();
            tpTicketListener.registerAndLoad();
        } else {
            MessageUtils.logInfo("&cRedis &fis not connected. Disabling Redis features...");
        }
    }

    public static void withConnection(Consumer<StatefulRedisConnection<String, String>> consumer) {
        try (RedisClient client = OwnRedisClient.create();){
            StatefulRedisConnection<String, String> r = client.connect();
            consumer.accept(r);
        }
    }

    public static void withPubSubConnection(Consumer<StatefulRedisPubSubConnection<String, String>> consumer) {
        try (RedisClient client = OwnRedisClient.create();){
            StatefulRedisPubSubConnection<String, String> r = client.connectPubSub();
            consumer.accept(r);
        }
    }

    public static void withRedis(Consumer<RedisCommands<String, String>> consumer) {
        OwnRedisClient.withConnection(connection -> {
            RedisCommands r = connection.sync();
            consumer.accept(r);
        });
    }

    public static void withReactive(Consumer<RedisStringReactiveCommands<String, String>> consumer) {
        OwnRedisClient.withConnection(connection -> {
            RedisReactiveCommands r = connection.reactive();
            consumer.accept(r);
        });
    }

    public static void withPubSub(Consumer<RedisPubSubCommands<String, String>> consumer) {
        OwnRedisClient.withPubSubConnection(connection -> {
            RedisCommands r = connection.sync();
            consumer.accept((RedisPubSubCommands<String, String>)r);
        });
    }

    public static void init() {
        if (OwnRedisClient.isEnabled()) {
            OwnRedisClient.testConnection();
        } else {
            MessageUtils.logInfo("&cRedis &fis not enabled in the configuration. Skipping initialization...");
        }
    }

    public static void sendMessage(RedisMessage message) {
        OwnRedisClient.withRedis(commands -> {
            commands.publish(message.getChannel(), message.getMessage());
            MessageUtils.logDebug("Sent Redis message on channel: " + message.getChannel() + " with content: " + message.getMessage());
        });
    }

    public static AtomicBoolean getConnectedAtomic() {
        return connectedAtomic;
    }

    public static void setConnectedAtomic(AtomicBoolean connectedAtomic) {
        OwnRedisClient.connectedAtomic = connectedAtomic;
    }

    public static TPTicketListener getTpTicketListener() {
        return tpTicketListener;
    }

    public static void setTpTicketListener(TPTicketListener tpTicketListener) {
        OwnRedisClient.tpTicketListener = tpTicketListener;
    }

    public static RedisClient getRedisClient() {
        return redisClient;
    }

    public static void setRedisClient(RedisClient redisClient) {
        OwnRedisClient.redisClient = redisClient;
    }
}

