/*
 * Decompiled with CFR 0.152.
 */
package singularity.scheduler;

import java.util.Date;
import singularity.scheduler.TaskManager;
import singularity.utils.MessageUtils;

public abstract class BaseRunnable
implements Runnable {
    private Date startedAt = new Date();
    private long currentTickCount;
    private long period;
    private int index;

    public BaseRunnable(long delay, long period) {
        this.currentTickCount = delay * -1L;
        this.period = period;
        this.index = TaskManager.getNextIndex();
        TaskManager.start(this);
    }

    public void tick() {
        if (this.currentTickCount >= this.period) {
            this.currentTickCount = 0L;
            try {
                this.run();
            }
            catch (Throwable e) {
                MessageUtils.logDebug("Error while ticking runnable: " + String.valueOf(this), e);
            }
        }
        ++this.currentTickCount;
    }

    public void cancel() {
        TaskManager.cancel(this);
    }

    public boolean isCancelled() {
        return !TaskManager.getCurrentRunnables().containsKey(this.index);
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public void setCurrentTickCount(long currentTickCount) {
        this.currentTickCount = currentTickCount;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public long getCurrentTickCount() {
        return this.currentTickCount;
    }

    public long getPeriod() {
        return this.period;
    }

    public int getIndex() {
        return this.index;
    }
}

