/*
 * Decompiled with CFR 0.152.
 */
package singularity.scheduler;

import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.Timer;
import singularity.scheduler.BaseRunnable;
import singularity.utils.MessageUtils;

public class TaskManager {
    private static ConcurrentSkipListMap<Integer, BaseRunnable> currentRunnables = new ConcurrentSkipListMap();
    private static Timer timer;

    public static void start(BaseRunnable runnable) {
        currentRunnables.put(runnable.getIndex(), runnable);
    }

    public static void cancel(BaseRunnable runnable) {
        TaskManager.cancel(runnable.getIndex());
    }

    public static int getNextIndex() {
        return currentRunnables.size();
    }

    public static void tick() {
        for (BaseRunnable runnable : currentRunnables.values()) {
            try {
                runnable.tick();
            }
            catch (Throwable e) {
                MessageUtils.logDebug("Error while ticking runnable: " + String.valueOf(runnable), e);
            }
        }
    }

    public static void stop() {
        timer.stop();
        currentRunnables.clear();
    }

    public static boolean isCancelled(int index) {
        return !currentRunnables.containsKey(index);
    }

    public static void cancel(int index) {
        currentRunnables.remove(index);
    }

    public static BaseRunnable getRunnable(int index) {
        return currentRunnables.get(index);
    }

    public static void init() {
        timer = new Timer(50, e -> TaskManager.tick());
        timer.start();
        MessageUtils.logInfo("&cTaskManager &fis now initialized!");
    }

    public static ConcurrentSkipListMap<Integer, BaseRunnable> getCurrentRunnables() {
        return currentRunnables;
    }

    public static void setCurrentRunnables(ConcurrentSkipListMap<Integer, BaseRunnable> currentRunnables) {
        TaskManager.currentRunnables = currentRunnables;
    }

    public static Timer getTimer() {
        return timer;
    }

    public static void setTimer(Timer timer) {
        TaskManager.timer = timer;
    }
}

