/*
 * Decompiled with CFR 0.152.
 */
package singularity.timers;

import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import singularity.configs.given.GivenConfigs;
import singularity.data.teleportation.TPTicket;
import singularity.redis.OwnRedisClient;
import singularity.scheduler.BaseRunnable;
import singularity.utils.MessageUtils;

public class TPTicketPuller
extends BaseRunnable {
    private static AtomicBoolean running = new AtomicBoolean(false);

    public TPTicketPuller() {
        super(0L, 5L);
        MessageUtils.logInfo("Registered &cTPTicket Puller&r...");
    }

    @Override
    public void run() {
        if (TPTicketPuller.isUseRedis()) {
            running.set(false);
            return;
        }
        if (running.get()) {
            return;
        }
        running.set(true);
        try {
            ConcurrentSkipListSet<TPTicket> set2 = GivenConfigs.getMainDatabase().pullAllTPTickets().join();
            if (set2 == null || set2.isEmpty()) {
                running.set(false);
                return;
            }
            set2.forEach(TPTicket::pend);
        }
        catch (Throwable e) {
            MessageUtils.logWarning("An error occurred while pulling TPTickets: " + e.getMessage());
            e.printStackTrace();
        }
        running.set(false);
    }

    public static boolean isUseRedis() {
        return GivenConfigs.getRedisConfig().isEnabled() && OwnRedisClient.isConnected();
    }

    public static AtomicBoolean getRunning() {
        return running;
    }

    public static void setRunning(AtomicBoolean running) {
        TPTicketPuller.running = running;
    }
}

