/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage;

import de.leonhard.storage.internal.FileData;
import de.leonhard.storage.internal.FileType;
import de.leonhard.storage.internal.FlatFile;
import de.leonhard.storage.internal.settings.ErrorHandler;
import de.leonhard.storage.internal.settings.ReloadSettings;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.shaded.json.JSONObject;
import de.leonhard.storage.shaded.json.JSONTokener;
import de.leonhard.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

public class Json
extends FlatFile {
    public Json(Json json) {
        super(json.getFile(), json.fileType, json.pathSeparator());
        this.fileData = json.getFileData();
        this.pathPrefix = json.getPathPrefixArray();
    }

    public Json(String name, String path) {
        this(name, path, null);
    }

    public Json(String name, String path, InputStream inputStream) {
        this(name, path, inputStream, null);
    }

    public Json(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings) {
        this(name, path, inputStream, reloadSettings, null);
    }

    public Json(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, null, reloadConsumer);
    }

    public Json(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        this(name, path, inputStream, reloadSettings, null, pathPattern, reloadConsumer);
    }

    public Json(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ErrorHandler errorHandler, @Nullable String pathPattern, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.JSON, pathPattern, reloadConsumer);
        if ((this.create() || this.file.length() == 0L) && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        this.forceReload();
    }

    public Json(File file) {
        super(file, FileType.JSON);
        this.create();
        this.forceReload();
    }

    @Override
    @NonNull
    public final Map<?, ?> getMap(String[] key) {
        String[] finalKey;
        String[] stringArray = finalKey = this.pathPrefix == null ? key : this.concatenatePath(this.pathPrefix, key);
        if (!this.contains(finalKey)) {
            return new HashMap();
        }
        Object map = this.get(key);
        if (map instanceof Map) {
            return (Map)this.fileData.get(key);
        }
        if (map instanceof JSONObject) {
            return ((JSONObject)map).toMap();
        }
        throw new IllegalArgumentException("ClassCastEx: Json contains key: '" + Arrays.toString(key) + "' but it is not a Map");
    }

    @Override
    protected final Map<String, Object> readToMap() throws IOException {
        if (this.file.length() == 0L) {
            Files.write(this.file.toPath(), Collections.singletonList("{}"), new OpenOption[0]);
        }
        JSONTokener jsonTokener = new JSONTokener(FileUtils.createInputStream(this.file));
        return new JSONObject(jsonTokener).toMap();
    }

    @Override
    protected final void write(FileData data) throws IOException {
        Writer writer = FileUtils.createWriter(this.file);
        try {
            writer.write(data.toJsonObject().toString(3));
            writer.flush();
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }
}

