/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal;

import de.leonhard.storage.internal.exceptions.SimplixValidationException;
import de.leonhard.storage.internal.provider.SimplixProviders;
import de.leonhard.storage.internal.serialize.SimplixSerializableLike;
import de.leonhard.storage.internal.serialize.SimplixSerializerManager;
import de.leonhard.storage.shaded.jetbrains.annotations.Contract;
import de.leonhard.storage.shaded.jetbrains.annotations.NotNull;
import de.leonhard.storage.shaded.jetbrains.annotations.Nullable;
import de.leonhard.storage.util.ClassWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface DataStorage {
    @Nullable
    public Object get(String[] var1);

    public boolean contains(String[] var1);

    public String pathSeparator();

    default public void set(String[] key, Object value) {
        this.set(key, value, true);
    }

    default public void set(String[] key, Object value, @Nullable Boolean sub) {
        if (sub != null) {
            if (sub.booleanValue()) {
                this.setRaw(key, SimplixSerializerManager.resolveAll(value));
            } else {
                this.setRaw(key, SimplixSerializerManager.resolveSingle(value));
            }
        } else if (value instanceof SimplixSerializableLike) {
            SimplixSerializableLike s2 = (SimplixSerializableLike)value;
            this.setRaw(key, s2.serialized());
        } else {
            this.setRaw(key, value);
        }
    }

    public void setRaw(String[] var1, Object var2);

    public Set<String> singleLayerKeySet();

    public Set<String> keySet();

    public Set<String> keySet(String[] var1);

    public Set<String> singleLayerKeySet(String[] var1);

    public void remove(String[] var1);

    @Nullable
    default public Object get(String key) {
        return this.get(this.splitPath(key));
    }

    default public boolean contains(String key) {
        return this.contains(this.splitPath(key));
    }

    default public String[] splitPath(String path) {
        return path.split(Pattern.quote(this.pathSeparator()));
    }

    default public String createPath(@NotNull String first, String ... other) {
        if (other.length == 0) {
            return first;
        }
        StringBuilder sb = new StringBuilder(first);
        for (String o : other) {
            sb.append(this.pathSeparator()).append(o);
        }
        return sb.toString();
    }

    default public String createPath(String[] path) {
        StringBuilder sb = null;
        for (String o : path) {
            if (sb == null) {
                sb = new StringBuilder(o);
                continue;
            }
            sb.append(this.pathSeparator()).append(o);
        }
        return sb == null ? "" : sb.toString();
    }

    default public String[] concatenatePath(String[] first, String[] second) {
        return (String[])Stream.concat(Arrays.stream(first), Arrays.stream(second)).toArray(String[]::new);
    }

    default public void set(String key, Object value) {
        this.set(this.splitPath(key), value);
    }

    default public Set<String> singleLayerKeySet(String key) {
        return this.singleLayerKeySet(this.splitPath(key));
    }

    default public Set<String> keySet(String key) {
        return this.keySet(this.splitPath(key));
    }

    default public void remove(String key) {
        this.remove(this.splitPath(key));
    }

    default public <T> T get(String[] key, T def) {
        return this.getOrDefault(key, def);
    }

    default public <T> T get(String key, T def) {
        return this.getOrDefault(key, def);
    }

    @NotNull
    default public <T> T getOrThrow(String[] key, T def) {
        try {
            Object raw = Objects.requireNonNull(this.get(key));
            return ClassWrapper.getFromDef(raw, def);
        }
        catch (ClassCastException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot cast the value to the given type for key '" + this.createPath(key) + "'");
        }
        catch (NullPointerException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot found a value for key '" + this.createPath(key) + "'");
        }
        catch (Exception e) {
            throw new SimplixValidationException((Throwable)e, "An error occurred while getting the key '" + this.createPath(key) + "'");
        }
    }

    @NotNull
    default public <T> T getOrThrow(String key, T def) {
        return this.getOrThrow(this.splitPath(key), def);
    }

    @NotNull
    default public <T> T getOrThrow(String[] key, Class<T> type) {
        try {
            Object raw = Objects.requireNonNull(this.get(key));
            return ClassWrapper.getFromDef(raw, type);
        }
        catch (ClassCastException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot cast the value to the given type for key '" + this.createPath(key) + "'");
        }
        catch (NullPointerException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot found a value for key '" + this.createPath(key) + "'");
        }
        catch (Exception e) {
            throw new SimplixValidationException((Throwable)e, "An error occurred while getting the key '" + this.createPath(key) + "'");
        }
    }

    @NotNull
    default public <T> T getOrThrow(String key, Class<T> type) {
        return this.getOrThrow(this.splitPath(key), type);
    }

    @Nullable
    default public <T> T getRaw(String[] key, T type) {
        Object raw = this.get(key);
        return raw == null ? null : (T)ClassWrapper.getFromDef(raw, type);
    }

    @Nullable
    default public <T> T getRaw(String key, T type) {
        return this.getRaw(this.splitPath(key), type);
    }

    @Nullable
    default public <T> T getRaw(String[] key, Class<T> type) {
        Object raw = this.get(key);
        return raw == null ? null : (T)ClassWrapper.getFromDef(raw, type);
    }

    @Nullable
    default public <T> T getRaw(String key, Class<T> type) {
        return this.getRaw(this.splitPath(key), type);
    }

    @Nullable
    default public <T> T getRawOrThrow(String[] key, T type) {
        try {
            return this.getRaw(key, type);
        }
        catch (ClassCastException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot cast the value to the given type for key '" + this.createPath(key) + "'");
        }
        catch (Exception e) {
            throw new SimplixValidationException((Throwable)e, "An error occurred while getting the key '" + this.createPath(key) + "'");
        }
    }

    @Nullable
    default public <T> T getRawOrThrow(String key, T type) {
        return this.getRawOrThrow(this.splitPath(key), type);
    }

    @Nullable
    default public <T> T getRawOrThrow(String[] key, Class<T> type) {
        try {
            return this.getRaw(key, type);
        }
        catch (ClassCastException e) {
            throw new SimplixValidationException((Throwable)e, "Cannot cast the value to the given type for key '" + this.createPath(key) + "'");
        }
        catch (Exception e) {
            throw new SimplixValidationException((Throwable)e, "An error occurred while getting the key '" + this.createPath(key) + "'");
        }
    }

    @Nullable
    default public <T> T getRawOrThrow(String key, Class<T> type) {
        return this.getRawOrThrow(this.splitPath(key), type);
    }

    default public Optional<Object> findRaw(String[] key) {
        return Optional.ofNullable(this.get(key));
    }

    default public Optional<Object> findRaw(String key) {
        return this.findRaw(this.splitPath(key));
    }

    default public <T> Optional<T> find(String[] key, Class<T> type) {
        return Optional.ofNullable(this.getRaw(key, type));
    }

    default public <T> Optional<T> find(String key, Class<T> type) {
        return this.find(this.splitPath(key), (T)type);
    }

    default public <T> Optional<T> find(String[] key, T type) {
        return Optional.ofNullable(this.getRaw(key, type));
    }

    default public <T> Optional<T> find(String key, T type) {
        return this.find(this.splitPath(key), type);
    }

    @Nullable
    default public String getRawString(String[] key) {
        return this.getRaw(key, "");
    }

    @Nullable
    default public String getRawString(String key) {
        return this.getRaw(key, "");
    }

    @NotNull
    default public String getString(String[] key) {
        return this.getOrDefault(key, "");
    }

    default public String getString(String key) {
        return this.getOrDefault(key, "");
    }

    default public long getLong(String key) {
        return this.getOrDefault(key, Long.valueOf(0L));
    }

    default public int getInt(String key) {
        return this.getOrDefault(key, Integer.valueOf(0));
    }

    default public byte getByte(String key) {
        return this.getOrDefault(key, Byte.valueOf((byte)0));
    }

    default public boolean getBoolean(String key) {
        return this.getOrDefault(key, Boolean.valueOf(false));
    }

    default public float getFloat(String key) {
        return this.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
    }

    default public double getDouble(String key) {
        return this.getOrDefault(key, Double.valueOf(0.0));
    }

    @NotNull
    default public List<?> getList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    @NotNull
    default public List<?> getList(String[] key) {
        return this.getOrDefault(key, new ArrayList());
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getList(String[] key, T type, @Nullable List<T> def) {
        Object raw = this.get(key);
        if (raw instanceof List) {
            return ClassWrapper.getListFromType((List)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getList(String key, T type, @Nullable List<T> def) {
        return this.getList(this.splitPath(key), type, def);
    }

    @NotNull
    default public <T> List<T> getList(String[] key, T type) {
        return this.getList(key, type, new ArrayList());
    }

    @NotNull
    default public <T> List<T> getList(String key, T type) {
        return this.getList(this.splitPath(key), type);
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getList(String[] key, Class<T> type, @Nullable List<T> def) {
        Object raw = this.get(key);
        if (raw instanceof List) {
            return ClassWrapper.getListFromType((List)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getList(String key, Class<T> type, @Nullable List<T> def) {
        return this.getList(this.splitPath(key), type, def);
    }

    @NotNull
    default public <T> List<T> getList(String[] key, Class<T> type) {
        return this.getList(key, type, (List<T>)new ArrayList());
    }

    @NotNull
    default public <T> List<T> getList(String key, Class<T> type) {
        return this.getList(this.splitPath(key), type);
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getListFiltered(String[] key, T type, @Nullable List<T> def) {
        Object raw = this.get(key);
        if (raw instanceof List) {
            return ClassWrapper.getListFromTypeFilter((List)raw, type);
        }
        return def;
    }

    default public <T> List<T> getListFiltered(String[] key, T type) {
        return this.getListFiltered(key, type, new ArrayList());
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> List<T> getListFiltered(String[] key, Class<T> type, @Nullable List<T> def) {
        Object raw = this.get(key);
        if (raw instanceof List) {
            return ClassWrapper.getListFromTypeFilter((List)raw, type);
        }
        return def;
    }

    default public <T> List<T> getListFiltered(String[] key, Class<T> type) {
        return this.getListFiltered(key, type, (List<T>)new ArrayList());
    }

    @NotNull
    default public <T> List<T> getMappedList(String key, Function<Object, T> mapper) {
        return this.getMappedList(this.splitPath(key), mapper);
    }

    @NotNull
    default public <T> List<T> getMappedList(String[] key, Function<Object, T> mapper) {
        Object raw = this.get(key);
        return raw == null ? new ArrayList() : ClassWrapper.getFromDef(raw, new ArrayList()).stream().map(mapper).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getMappedListFiltered(String key, Function<Object, T> mapper) {
        return this.getMappedListFiltered(this.splitPath(key), mapper);
    }

    @NotNull
    default public <T> List<T> getMappedListFiltered(String[] key, Function<Object, T> mapper) {
        Object raw = this.get(key);
        return raw == null ? new ArrayList() : ClassWrapper.getFromDef(raw, new ArrayList()).stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getStringMappedList(String key, Function<String, T> mapper) {
        return this.getStringMappedList(this.splitPath(key), mapper);
    }

    @NotNull
    default public <T> List<T> getStringMappedList(String[] key, Function<String, T> mapper) {
        Object raw = this.get(key);
        return raw == null ? new ArrayList() : ClassWrapper.getFromDef(raw, new ArrayList()).stream().map(mapper).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getStringMappedListFiltered(String key, Function<String, T> mapper) {
        return this.getStringMappedListFiltered(this.splitPath(key), mapper);
    }

    @NotNull
    default public <T> List<T> getStringMappedListFiltered(String[] key, Function<String, T> mapper) {
        Object raw = this.get(key);
        return raw == null ? new ArrayList() : ClassWrapper.getFromDef(raw, new ArrayList()).stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getListParameterized(String key) {
        return this.getOrSetDefault(key, new ArrayList());
    }

    @NotNull
    default public List<String> getStringList(String key) {
        return this.getOrDefault(key, new ArrayList());
    }

    @NotNull
    default public List<String> getStringList(String[] key) {
        return this.getOrDefault(key, new ArrayList());
    }

    @NotNull
    default public List<Integer> getIntegerList(String key) {
        return this.getOrDefault(key, new ArrayList()).stream().map(Integer::parseInt).collect(Collectors.toList());
    }

    @NotNull
    default public List<Byte> getByteList(String key) {
        return this.getOrDefault(key, new ArrayList()).stream().map(Byte::parseByte).collect(Collectors.toList());
    }

    @NotNull
    default public List<Long> getLongList(String key) {
        return this.getOrDefault(key, new ArrayList()).stream().map(Long::parseLong).collect(Collectors.toList());
    }

    @NotNull
    default public Map<?, ?> getMap(String[] key) {
        return this.getOrDefault(key, new HashMap());
    }

    @NotNull
    default public Map<?, ?> getMap(String key) {
        return this.getMap(this.splitPath(key));
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMap(String[] key, Function<Object, T> mapper, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromType((Map)raw, mapper);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMap(String[] key, T type, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromType((Map)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMap(String[] key, Class<T> type, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromType((Map)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMap(String[] key, K keyType, V valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromType((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMap(String[] key, Class<K> keyType, Class<V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromType((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMap(String[] key, Function<Object, K> keyType, Function<Object, V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeMapper((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMapStr(String[] key, Function<String, K> keyType, Function<Object, V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeMapperStr((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMapFiltered(String[] key, T type, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilter((Map)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMapFiltered(String[] key, Class<T> type, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilter((Map)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMapFiltered(String[] key, K keyType, V valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilter((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMapFiltered(String[] key, Class<K> keyType, Class<V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilter((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, !null -> !null")
    default public <T> Map<String, T> getMapFiltered(String[] key, Function<Object, T> type, @Nullable Map<String, T> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilter((Map)raw, type);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMapFiltered(String[] key, Function<Object, K> keyType, Function<Object, V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilterMapper((Map)raw, keyType, valueType);
        }
        return def;
    }

    @Nullable
    @Contract(value="_, _, _, !null -> !null")
    default public <K, V> Map<K, V> getMapFilteredStr(String[] key, Function<String, K> keyType, Function<Object, V> valueType, @Nullable Map<K, V> def) {
        Object raw = this.get(key);
        if (raw instanceof Map) {
            return ClassWrapper.getMapFromTypeFilterMapperStr((Map)raw, keyType, valueType);
        }
        return def;
    }

    @NotNull
    default public <K, V> Map<K, V> getMapParameterized(String key) {
        return this.getOrSetDefault(key, new HashMap());
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String[] key, Class<E> type) {
        return this.getStringMappedList(key, (String s2) -> Enum.valueOf(type, s2));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String key, Class<E> type) {
        return this.getStringMappedList(key, (String s2) -> Enum.valueOf(type, s2));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String[] key, Class<E> type, Function<String, String> mapper) {
        return this.getStringMappedList(key, (String s2) -> Enum.valueOf(type, (String)mapper.apply((String)s2)));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String key, Class<E> type, Function<String, String> mapper) {
        return this.getStringMappedList(key, (String s2) -> Enum.valueOf(type, (String)mapper.apply((String)s2)));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String[] key, Function<String, E> mapper) {
        return this.getStringMappedList(key, mapper);
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumList(String key, Function<String, E> mapper) {
        return this.getStringMappedList(key, mapper);
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String[] key, Class<E> type) {
        return this.getStringMappedListFiltered(key, (String s2) -> Enum.valueOf(type, s2));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String key, Class<E> type) {
        return this.getStringMappedListFiltered(key, (String s2) -> Enum.valueOf(type, s2));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String[] key, Class<E> type, Function<String, String> mapper) {
        return this.getStringMappedListFiltered(key, (String s2) -> Enum.valueOf(type, (String)mapper.apply((String)s2)));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String key, Class<E> type, Function<String, String> mapper) {
        return this.getStringMappedListFiltered(key, (String s2) -> Enum.valueOf(type, (String)mapper.apply((String)s2)));
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String[] key, Function<String, E> mapper) {
        return this.getStringMappedListFiltered(key, mapper);
    }

    @NotNull
    default public <E extends Enum<E>> List<E> getEnumListFiltered(String key, Function<String, E> mapper) {
        return this.getStringMappedListFiltered(key, mapper);
    }

    private String stringForEnum(String[] key) {
        String value;
        try {
            value = this.getRaw(key, String.class);
        }
        catch (ClassCastException e) {
            throw new SimplixValidationException((Throwable)e, "No usable Enum-Value found for '" + this.createPath(key) + "'.");
        }
        catch (Exception e) {
            throw new SimplixValidationException((Throwable)e, "An error occurred while getting the key '" + this.createPath(key) + "'");
        }
        if (value == null) {
            throw new SimplixValidationException(new String[]{"Null Enum-Value was found for '" + this.createPath(key) + "'."});
        }
        return value;
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String[] key, Class<E> enumType) {
        String value = this.stringForEnum(key);
        return Enum.valueOf(enumType, value);
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String key, Class<E> enumType) {
        return this.getEnum(this.splitPath(key), enumType);
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String[] key, Class<E> enumType, Function<String, String> mapper) {
        String value = this.stringForEnum(key);
        return Enum.valueOf(enumType, mapper.apply(value));
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String key, Class<E> enumType, Function<String, String> mapper) {
        return this.getEnum(this.splitPath(key), enumType, mapper);
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String[] key, Function<String, E> mapper) {
        String value = this.stringForEnum(key);
        return (E)((Enum)mapper.apply(value));
    }

    @NotNull
    default public <E extends Enum<E>> E getEnum(String key, Function<String, E> mapper) {
        return this.getEnum(this.splitPath(key), mapper);
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String[] key, Class<E> enumType) {
        if (!this.contains(key)) {
            return null;
        }
        String value = this.stringForEnum(key);
        return Enum.valueOf(enumType, value);
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String key, Class<E> enumType) {
        return (E)((Enum)this.getRaw(this.splitPath(key), enumType));
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String[] key, Class<E> enumType, Function<String, String> mapper) {
        if (!this.contains(key)) {
            return null;
        }
        String value = this.stringForEnum(key);
        return Enum.valueOf(enumType, mapper.apply(value));
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String key, Class<E> enumType, Function<String, String> mapper) {
        return this.getRawEnum(this.splitPath(key), enumType, mapper);
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String[] key, Function<String, E> mapper) {
        if (!this.contains(key)) {
            return null;
        }
        String value = this.stringForEnum(key);
        return (E)((Enum)mapper.apply(value));
    }

    @Nullable
    default public <E extends Enum<E>> E getRawEnum(String key, Function<String, E> mapper) {
        return this.getRawEnum(this.splitPath(key), mapper);
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String[] key, Class<E> enumType) {
        return Optional.ofNullable(this.getRawEnum(key, enumType));
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String key, Class<E> enumType) {
        return this.findEnum(this.splitPath(key), enumType);
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String[] key, Class<E> enumType, Function<String, String> mapper) {
        return Optional.ofNullable(this.getRawEnum(key, enumType, mapper));
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String key, Class<E> enumType, Function<String, String> mapper) {
        return this.findEnum(this.splitPath(key), enumType, mapper);
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String[] key, Function<String, E> mapper) {
        return Optional.ofNullable(this.getRawEnum(key, mapper));
    }

    default public <E extends Enum<E>> Optional<E> findEnum(String key, Function<String, E> mapper) {
        return this.findEnum(this.splitPath(key), mapper);
    }

    default public <T> void setSerializable(@NotNull String key, @NotNull T value) {
        try {
            Object data = SimplixSerializerManager.serialize(value);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize: '" + key + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializable(@NotNull String[] key, @NotNull T value, @NotNull Class<T> type) {
        try {
            Object data = SimplixSerializerManager.serialize(value, type);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize: '" + this.createPath(key) + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializable(@NotNull String key, @NotNull T value, @NotNull Class<T> type) {
        this.setSerializable(this.splitPath(key), value, type);
    }

    default public <T> void setSerializableList(@NotNull String[] key, @NotNull List<T> value, @NotNull Class<T> type) {
        try {
            List<Object> data = SimplixSerializerManager.serializeList(value, type);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize list: '" + this.createPath(key) + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializableList(@NotNull String key, @NotNull List<T> value, @NotNull Class<T> type) {
        this.setSerializableList(this.splitPath(key), value, type);
    }

    default public <T> void setSerializableListFiltered(@NotNull String[] key, @NotNull List<T> value, @NotNull Class<T> type) {
        try {
            List<Object> data = SimplixSerializerManager.serializeListFiltered(value, type);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize list: '" + this.createPath(key) + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializableListFiltered(@NotNull String key, @NotNull List<T> value, @NotNull Class<T> type) {
        this.setSerializableListFiltered(this.splitPath(key), value, type);
    }

    default public <T> void setSerializableMap(@NotNull String[] key, @NotNull Map<String, T> value, @NotNull Class<T> type) {
        try {
            Map<String, Object> data = SimplixSerializerManager.serializeMap(value, type);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize map: '" + this.createPath(key) + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializableMap(@NotNull String key, @NotNull Map<String, T> value, @NotNull Class<T> type) {
        this.setSerializableMap(this.splitPath(key), value, type);
    }

    default public <T> void setSerializableMapFiltered(@NotNull String[] key, @NotNull Map<String, T> value, @NotNull Class<T> type) {
        try {
            Map<String, Object> data = SimplixSerializerManager.serializeMapFiltered(value, type);
            this.set(key, data);
        }
        catch (Throwable throwable) {
            throw SimplixProviders.exceptionHandler().create(throwable, "Can't serialize map: '" + this.createPath(key) + "'", "Class: '" + value.getClass().getName() + "'", "Package: '" + value.getClass().getPackage() + "'");
        }
    }

    default public <T> void setSerializableMapFiltered(@NotNull String key, @NotNull Map<String, T> value, @NotNull Class<T> type) {
        this.setSerializableMapFiltered(this.splitPath(key), value, type);
    }

    @Nullable
    default public <T> T getSerializable(String[] key, Object data, Class<T> type) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, data, type);
        }
        return null;
    }

    @Nullable
    default public <T> T getSerializable(String[] key, Class<T> type) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, type);
        }
        return null;
    }

    @Nullable
    default public <T> T getSerializable(String key, Class<T> type) {
        return this.getSerializable(this.splitPath(key), type);
    }

    @NotNull
    default public <T> T getOrDefSerializable(String[] key, Object data, Class<T> type, T def) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, data, type);
        }
        return def;
    }

    @NotNull
    default public <T> T getOrDefSerializable(String[] key, Class<T> type, T def) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, type);
        }
        return def;
    }

    @NotNull
    default public <T> T getOrDefSerializable(String key, Class<T> type, T def) {
        return this.getOrDefSerializable(this.splitPath(key), type, def);
    }

    @NotNull
    default public <T> Optional<T> findSerializable(String[] key, Object data, Class<T> type) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return Optional.of(SimplixSerializerManager.deserialize(raw, data, type));
        }
        return Optional.empty();
    }

    @NotNull
    default public <T> Optional<T> findSerializable(String[] key, Class<T> type) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return Optional.of(SimplixSerializerManager.deserialize(raw, type));
        }
        return Optional.empty();
    }

    @NotNull
    default public <T> Optional<T> findSerializable(String key, Class<T> type) {
        return this.findSerializable(this.splitPath(key), type);
    }

    @NotNull
    default public <T> List<T> getSerializableList(String[] key, Object data, Class<T> type) {
        List<?> rawList = this.getList(key);
        return SimplixSerializerManager.deserializeList(rawList, data, type);
    }

    @NotNull
    default public <T> List<T> getSerializableList(String[] key, Class<T> type) {
        List<?> rawList = this.getList(key);
        return SimplixSerializerManager.deserializeList(rawList, type);
    }

    @NotNull
    default public <T> List<T> getSerializableList(String key, Class<T> type) {
        return this.getSerializableList(this.splitPath(key), type);
    }

    @NotNull
    default public <T> List<T> getSerializableListFiltered(String[] key, Object data, Class<T> type) {
        List<?> rawList = this.getList(key);
        return SimplixSerializerManager.deserializeListFiltered(rawList, data, type);
    }

    @NotNull
    default public <T> List<T> getSerializableListFiltered(String[] key, Class<T> type) {
        List<?> rawList = this.getList(key);
        return SimplixSerializerManager.deserializeListFiltered(rawList, type);
    }

    @NotNull
    default public <T> List<T> getSerializableListFiltered(String key, Class<T> type) {
        return this.getSerializableListFiltered(this.splitPath(key), type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMap(String[] key, Object data, Class<T> type) {
        Map<?, ?> rawMap = this.getMap(key);
        return SimplixSerializerManager.deserializeMap(rawMap, data, type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMap(String[] key, Class<T> type) {
        Map<?, ?> rawMap = this.getMap(key);
        return SimplixSerializerManager.deserializeMap(rawMap, type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMap(String key, Class<T> type) {
        return this.getSerializableMap(this.splitPath(key), type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMapFiltered(String[] key, Object data, Class<T> type) {
        Map<?, ?> rawMap = this.getMap(key);
        return SimplixSerializerManager.deserializeMapFiltered(rawMap, data, type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMapFiltered(String[] key, Class<T> type) {
        Map<?, ?> rawMap = this.getMap(key);
        return SimplixSerializerManager.deserializeMapFiltered(rawMap, type);
    }

    @NotNull
    default public <T> Map<String, T> getSerializableMapFiltered(String key, Class<T> type) {
        return this.getSerializableMapFiltered(this.splitPath(key), type);
    }

    default public <T> T getOrDefault(String[] key, @NotNull T def) {
        Object raw = this.get(key);
        return raw == null ? def : ClassWrapper.getFromDef(raw, def);
    }

    default public <T> T getOrDefault(String key, @NotNull T def) {
        Object raw = this.get(key);
        return raw == null ? def : ClassWrapper.getFromDef(raw, def);
    }

    @NotNull
    default public <T> List<T> getOrSetList(String[] key, Function<String, T> mapper, List<String> rawDefault) {
        return this.getOrDefault(key, rawDefault).stream().map(mapper).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getOrSetList(String key, Function<String, T> mapper, List<String> rawDefault) {
        return this.getOrSetList(this.splitPath(key), mapper, rawDefault);
    }

    @NotNull
    default public <T> List<T> getOrSetListFiltered(String[] key, Function<String, T> mapper, List<String> rawDefault) {
        return this.getOrSetDefault(key, rawDefault).stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    default public <T> List<T> getOrSetListFiltered(String key, Function<String, T> mapper, List<String> rawDefault) {
        return this.getOrSetListFiltered(this.splitPath(key), mapper, rawDefault);
    }

    @NotNull
    default public <T> T getOrSetSerializable(String[] key, Object data, Class<T> type, T def) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, data, type);
        }
        this.setSerializable(key, def, type);
        return def;
    }

    @NotNull
    default public <T> T getOrSetSerializable(String[] key, Class<T> type, T def) {
        Object raw;
        if (this.contains(key) && (raw = this.get(key)) != null) {
            return SimplixSerializerManager.deserialize(raw, type);
        }
        this.setSerializable(key, def, type);
        return def;
    }

    @NotNull
    default public <T> T getOrSetSerializable(String key, Class<T> type, T def) {
        return this.getOrSetSerializable(this.splitPath(key), type, def);
    }

    default public void setDefault(String[] key, Object value) {
        if (!this.contains(key)) {
            this.set(key, value);
        }
    }

    default public void setDefault(String key, Object value) {
        this.setDefault(this.splitPath(key), value);
    }

    default public <T> T getOrSetDefault(String[] key, T def) {
        Object raw = this.get(key);
        if (raw == null) {
            this.set(key, def);
            return def;
        }
        return ClassWrapper.getFromDef(raw, def);
    }

    default public <T> T getOrSetDefault(String key, T def) {
        return this.getOrSetDefault(this.splitPath(key), def);
    }
}

