/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.async;

import gg.drak.thebase.async.AsyncUtils;
import gg.drak.thebase.async.TaskLike;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.Timer;
import lombok.Generated;

public class AsyncTask
implements TaskLike<AsyncTask> {
    private long id;
    private Consumer<AsyncTask> consumer;
    private long delay;
    private long period;
    private long currentDelay;
    private long ticksLived;
    private int timesRan;
    private Timer timer;

    public AsyncTask(long id, Consumer<AsyncTask> consumer, long delay, long period) {
        this.id = id;
        this.consumer = consumer;
        this.delay = delay;
        this.period = period;
        this.currentDelay = delay;
        this.ticksLived = 0L;
        this.timesRan = 0;
        this.timer = this.createTimer();
    }

    public Timer createTimer() {
        return new Timer(50, e -> {
            try {
                this.tick();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    public void start() {
        if (this.timer.isRunning()) {
            return;
        }
        this.timer.start();
    }

    public void stop() {
        if (!this.timer.isRunning()) {
            return;
        }
        this.timer.stop();
    }

    public void reset() {
        this.ticksLived = 0L;
        this.timesRan = 0;
    }

    public void restart() {
        this.stop();
        this.reset();
        this.start();
    }

    public AsyncTask(Consumer<AsyncTask> consumer, long delay, long period) {
        this(AsyncUtils.getNextTaskId(), consumer, delay, period);
    }

    public AsyncTask(long id, Consumer<AsyncTask> consumer, long delay) {
        this(id, consumer, delay, -1L);
    }

    public AsyncTask(Consumer<AsyncTask> consumer, long delay) {
        this(AsyncUtils.getNextTaskId(), consumer, delay);
    }

    public AsyncTask(long id, Consumer<AsyncTask> consumer) {
        this(id, consumer, 0L, -1L);
    }

    public AsyncTask(Consumer<AsyncTask> consumer) {
        this(AsyncUtils.getNextTaskId(), consumer);
    }

    public long getWarpedTicks() {
        if (this.timesRan == 0) {
            return this.ticksLived;
        }
        return this.ticksLived - this.period * (long)this.timesRan;
    }

    public long getNeededTicks() {
        if (this.delay > 0L && this.timesRan == 0) {
            return this.delay;
        }
        if (this.period > 0L) {
            return this.period;
        }
        return -1L;
    }

    public CompletableFuture<Void> executeAsync() {
        return AsyncUtils.executeAsync(this::execute);
    }

    public CompletableFuture<Void> tick(boolean runAsync) {
        ++this.ticksLived;
        if (this.currentDelay > 0L) {
            --this.currentDelay;
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = this.doExecute(runAsync);
        if (this.isCompleted()) {
            this.remove();
        }
        return future;
    }

    public CompletableFuture<Void> doExecute(boolean runAsync) {
        ++this.timesRan;
        this.currentDelay = this.period;
        if (runAsync) {
            return this.executeAsync();
        }
        this.execute();
        return CompletableFuture.completedFuture(null);
    }

    public long queue() {
        this.start();
        return AsyncUtils.queueTask(this);
    }

    public void remove() {
        this.stop();
        AsyncUtils.removeTask(this);
    }

    public CompletableFuture<Void> tick() {
        return this.tick(true);
    }

    public void execute() {
        this.consumer.accept(this);
    }

    public boolean completedAtLeast(int times) {
        return this.timesRan >= times;
    }

    public boolean completedAtLeastOnce() {
        return this.completedAtLeast(1);
    }

    public boolean isCompleted() {
        if (this.isRepeatable()) {
            return false;
        }
        return this.completedAtLeastOnce();
    }

    public boolean isRepeatable() {
        return this.period > -1L;
    }

    @Override
    @Generated
    public long getId() {
        return this.id;
    }

    @Override
    @Generated
    public Consumer<AsyncTask> getConsumer() {
        return this.consumer;
    }

    @Override
    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Override
    @Generated
    public long getPeriod() {
        return this.period;
    }

    @Generated
    public long getCurrentDelay() {
        return this.currentDelay;
    }

    @Generated
    public long getTicksLived() {
        return this.ticksLived;
    }

    @Generated
    public int getTimesRan() {
        return this.timesRan;
    }

    @Generated
    public Timer getTimer() {
        return this.timer;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @Generated
    public void setConsumer(Consumer<AsyncTask> consumer) {
        this.consumer = consumer;
    }

    @Override
    @Generated
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    @Generated
    public void setPeriod(long period) {
        this.period = period;
    }

    @Generated
    public void setCurrentDelay(long currentDelay) {
        this.currentDelay = currentDelay;
    }

    @Generated
    public void setTicksLived(long ticksLived) {
        this.ticksLived = ticksLived;
    }

    @Generated
    public void setTimesRan(int timesRan) {
        this.timesRan = timesRan;
    }

    @Generated
    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

