/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.async;

import gg.drak.thebase.async.AsyncUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;

public class TaskThread
extends Thread {
    public static AtomicLong lastTick = new AtomicLong(System.currentTimeMillis());
    public static AtomicBoolean run = new AtomicBoolean(false);
    public static AtomicBoolean running = new AtomicBoolean(true);
    public static AtomicLong tickingFrequency = new AtomicLong(50L);

    public TaskThread() {
        super(TaskThread.getRunTask());
    }

    public void pauseTask() {
        running.set(false);
    }

    public void resumeTask() {
        running.set(true);
    }

    public void stopTask() {
        this.pauseTask();
        run.set(false);
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startTask() {
        run.set(true);
        this.resumeTask();
        this.start();
    }

    public void updateTickingFrequency(long frequency) {
        tickingFrequency.set(frequency);
    }

    public static Runnable getRunTask() {
        return () -> {
            try {
                while (true) {
                    if (!run.get()) {
                        return;
                    }
                    try {
                        TaskThread.tick();
                    }
                    catch (Throwable t2) {
                        System.out.println("An error occurred while executing the task thread: " + t2.getMessage());
                        t2.printStackTrace();
                    }
                    try {
                        Thread.sleep(tickingFrequency.get());
                    }
                    catch (Throwable t3) {
                        System.out.println("An error occurred while sleeping the task thread: " + t3.getMessage());
                        t3.printStackTrace();
                    }
                }
            }
            catch (Throwable t4) {
                System.out.println("An error occurred while executing the task thread: " + t4.getMessage());
                t4.printStackTrace();
                return;
            }
        };
    }

    public static void tick() {
        try {
            if (!running.get()) {
                return;
            }
            AsyncUtils.tickTasks();
            lastTick.set(System.currentTimeMillis());
        }
        catch (Throwable t2) {
            System.out.println("An error occurred while executing a task: " + t2.getMessage());
            t2.printStackTrace();
        }
    }

    @Generated
    public static AtomicLong getLastTick() {
        return lastTick;
    }

    @Generated
    public static void setLastTick(AtomicLong lastTick) {
        TaskThread.lastTick = lastTick;
    }

    @Generated
    public static AtomicBoolean getRun() {
        return run;
    }

    @Generated
    public static void setRun(AtomicBoolean run) {
        TaskThread.run = run;
    }

    @Generated
    public static AtomicBoolean getRunning() {
        return running;
    }

    @Generated
    public static void setRunning(AtomicBoolean running) {
        TaskThread.running = running;
    }

    @Generated
    public static AtomicLong getTickingFrequency() {
        return tickingFrequency;
    }

    @Generated
    public static void setTickingFrequency(AtomicLong tickingFrequency) {
        TaskThread.tickingFrequency = tickingFrequency;
    }
}

