/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.events;

import gg.drak.thebase.events.BaseEventListener;
import gg.drak.thebase.events.BaseListenerLayout;
import gg.drak.thebase.events.RegisteredListener;
import gg.drak.thebase.events.components.BaseEvent;
import gg.drak.thebase.events.components.FunctionedCall;
import gg.drak.thebase.objects.handling.IEventable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import lombok.Generated;

public class BaseEventHandler {
    private static ConcurrentSkipListSet<FunctionedCall<BaseEvent>> functions = new ConcurrentSkipListSet();
    private static ConcurrentSkipListMap<Integer, BaseEventListener> listeners = new ConcurrentSkipListMap();
    private static ConcurrentHashMap<Class<? extends BaseEvent>, ConcurrentSkipListSet<RegisteredListener<?>>> regularEvents = new ConcurrentHashMap();

    public static String getMethodNamed(Method method) {
        return method.getDeclaringClass().getSimpleName() + "::" + method.getName();
    }

    public static void put(Class<? extends BaseEvent> aClass, RegisteredListener<?> ... registeredListener) {
        ConcurrentSkipListSet<RegisteredListener<Object>> listeners = BaseEventHandler.getRegularEvents().get(aClass);
        if (listeners == null) {
            listeners = new ConcurrentSkipListSet();
        }
        listeners.addAll(Arrays.stream(registeredListener).collect(Collectors.toList()));
        BaseEventHandler.getRegularEvents().put(aClass, listeners);
    }

    public static void unput(Class<? extends BaseEvent> aClass, RegisteredListener<?> ... registeredListener) {
        ConcurrentSkipListSet<RegisteredListener<Object>> listeners = BaseEventHandler.getRegularEvents().get(aClass);
        if (listeners == null) {
            listeners = new ConcurrentSkipListSet();
        }
        Arrays.stream(registeredListener).collect(Collectors.toList()).forEach(listeners::remove);
        BaseEventHandler.getRegularEvents().put(aClass, listeners);
    }

    public static void bake(BaseEventListener listener, IEventable eventable) {
        BaseListenerLayout listenerLayout = new BaseListenerLayout(listener);
        listenerLayout.setUp(eventable).forEach((aClass, registeredListeners) -> BaseEventHandler.put(aClass, registeredListeners.toArray(new RegisteredListener[0])));
    }

    public static <T extends IEventable> void unbake(T eventable) {
        BaseEventHandler.getRegularEvents().forEach((aClass, registeredListeners) -> registeredListeners.forEach(registeredListener -> {
            if (registeredListener.getEventable().equals(eventable)) {
                BaseEventHandler.getRegularEvents().get(aClass).remove(registeredListener);
            }
        }));
    }

    public static void unbake(BaseEventListener listener, Class<? extends BaseEvent> clazz) {
        ConcurrentSkipListSet<RegisteredListener<?>> listeners = BaseEventHandler.getRegularEvents().get(clazz);
        if (listeners == null) {
            return;
        }
        listeners.forEach(registeredListener -> {
            if (registeredListener.getListener().equals(listener)) {
                BaseEventHandler.getRegularEvents().get(clazz).remove(registeredListener);
            }
        });
    }

    public static void unbake(BaseEventListener listener) {
        BaseEventHandler.getRegularEvents().forEach((aClass, registeredListeners) -> registeredListeners.forEach(registeredListener -> {
            if (registeredListener.getListener().equals(listener)) {
                BaseEventHandler.getRegularEvents().get(aClass).remove(registeredListener);
            }
        }));
    }

    public static void unbake(IEventable eventable, Class<? extends BaseEvent> clazz) {
        ConcurrentSkipListSet<RegisteredListener<?>> listeners = BaseEventHandler.getRegularEvents().get(clazz);
        if (listeners == null) {
            return;
        }
        listeners.forEach(registeredListener -> {
            if (registeredListener.getEventable().equals(eventable)) {
                BaseEventHandler.getRegularEvents().get(clazz).remove(registeredListener);
            }
        });
    }

    public static void unbake(Class<? extends BaseEvent> clazz) {
        BaseEventHandler.getRegularEvents().remove(clazz);
    }

    public static void unbakeAll() {
        BaseEventHandler.setRegularEvents(new ConcurrentHashMap());
    }

    public static ConcurrentSkipListSet<RegisteredListener<?>> getRegularListeners(Class<? extends BaseEvent> event) {
        ConcurrentSkipListSet listeners = new ConcurrentSkipListSet();
        BaseEventHandler.getRegularEvents().forEach((aClass, registeredListeners) -> {
            if (event.equals(aClass)) {
                listeners.addAll((Collection<RegisteredListener<?>>)registeredListeners);
            }
        });
        return listeners;
    }

    public static void fireEvent(BaseEvent event) {
        BaseEventHandler.getRegularListeners(event.getClass()).forEach(registeredListener -> {
            try {
                registeredListener.callEvent(event);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
        BaseEventHandler.getFunctions().forEach(function -> {
            if (function.getClazz().isAssignableFrom(event.getClass())) {
                function.fire(event);
            }
        });
    }

    public static <T extends BaseEvent> void loadFunction(FunctionedCall<T> functionedCall) {
        BaseEventHandler.getFunctions().add(functionedCall);
    }

    @Generated
    public static ConcurrentSkipListSet<FunctionedCall<BaseEvent>> getFunctions() {
        return functions;
    }

    @Generated
    public static void setFunctions(ConcurrentSkipListSet<FunctionedCall<BaseEvent>> functions) {
        BaseEventHandler.functions = functions;
    }

    @Generated
    public static ConcurrentSkipListMap<Integer, BaseEventListener> getListeners() {
        return listeners;
    }

    @Generated
    public static void setListeners(ConcurrentSkipListMap<Integer, BaseEventListener> listeners) {
        BaseEventHandler.listeners = listeners;
    }

    @Generated
    public static ConcurrentHashMap<Class<? extends BaseEvent>, ConcurrentSkipListSet<RegisteredListener<?>>> getRegularEvents() {
        return regularEvents;
    }

    @Generated
    public static void setRegularEvents(ConcurrentHashMap<Class<? extends BaseEvent>, ConcurrentSkipListSet<RegisteredListener<?>>> regularEvents) {
        BaseEventHandler.regularEvents = regularEvents;
    }
}

