/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj.jdbc.ha;

import gg.drak.thebase.lib.mysql.cj.jdbc.ConnectionImpl;
import gg.drak.thebase.lib.mysql.cj.jdbc.JdbcConnection;
import gg.drak.thebase.lib.mysql.cj.jdbc.ha.BalanceStrategy;
import gg.drak.thebase.lib.mysql.cj.jdbc.ha.LoadBalancedConnectionProxy;
import java.lang.reflect.InvocationHandler;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class SequentialBalanceStrategy
implements BalanceStrategy {
    private int currentHostIndex = -1;

    @Override
    public ConnectionImpl pickConnection(InvocationHandler proxy, List<String> configuredHosts, Map<String, JdbcConnection> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        int numHosts = configuredHosts.size();
        SQLException ex = null;
        Map<String, Long> blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
        for (int attempts = 0; attempts < numRetries; ++attempts) {
            if (numHosts == 1) {
                this.currentHostIndex = 0;
            } else if (this.currentHostIndex == -1) {
                int random;
                int i2;
                for (i2 = random = (int)Math.floor(Math.random() * (double)numHosts); i2 < numHosts; ++i2) {
                    if (blockList.containsKey(configuredHosts.get(i2))) continue;
                    this.currentHostIndex = i2;
                    break;
                }
                if (this.currentHostIndex == -1) {
                    for (i2 = 0; i2 < random; ++i2) {
                        if (blockList.containsKey(configuredHosts.get(i2))) continue;
                        this.currentHostIndex = i2;
                        break;
                    }
                }
                if (this.currentHostIndex == -1) {
                    blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException i3) {}
                    continue;
                }
            } else {
                int i4;
                boolean foundGoodHost = false;
                for (i4 = this.currentHostIndex + 1; i4 < numHosts; ++i4) {
                    if (blockList.containsKey(configuredHosts.get(i4))) continue;
                    this.currentHostIndex = i4;
                    foundGoodHost = true;
                    break;
                }
                if (!foundGoodHost) {
                    for (i4 = 0; i4 < this.currentHostIndex; ++i4) {
                        if (blockList.containsKey(configuredHosts.get(i4))) continue;
                        this.currentHostIndex = i4;
                        foundGoodHost = true;
                        break;
                    }
                }
                if (!foundGoodHost) {
                    blockList = ((LoadBalancedConnectionProxy)proxy).getGlobalBlocklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
            }
            String hostPortSpec = configuredHosts.get(this.currentHostIndex);
            ConnectionImpl conn = (ConnectionImpl)liveConnections.get(hostPortSpec);
            if (conn == null) {
                try {
                    conn = ((LoadBalancedConnectionProxy)proxy).createConnectionForHost(hostPortSpec);
                }
                catch (SQLException sqlEx) {
                    ex = sqlEx;
                    if (((LoadBalancedConnectionProxy)proxy).shouldExceptionTriggerConnectionSwitch(sqlEx)) {
                        ((LoadBalancedConnectionProxy)proxy).addToGlobalBlocklist(hostPortSpec);
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw sqlEx;
                }
            }
            return conn;
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }
}

