/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.storage.resources.flat;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.lib.leonhard.storage.Json;
import gg.drak.thebase.lib.leonhard.storage.SimplixBuilder;
import gg.drak.thebase.lib.leonhard.storage.Toml;
import gg.drak.thebase.lib.leonhard.storage.Yaml;
import gg.drak.thebase.lib.leonhard.storage.internal.FlatFile;
import gg.drak.thebase.storage.StorageUtils;
import gg.drak.thebase.storage.resources.StorageResource;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Scanner;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import lombok.Generated;

public class FlatFileResource<T extends FlatFile>
extends StorageResource<T> {
    T resource;
    final String fileName;
    final File parentDirectory;
    final File selfFile;
    final boolean selfContained;

    public FlatFileResource(Class<T> resourceType, String fileName, File parentDirectory, boolean selfContained) {
        super(resourceType, "name", fileName);
        this.fileName = fileName;
        this.parentDirectory = parentDirectory;
        this.selfFile = new File(parentDirectory, fileName);
        this.selfContained = selfContained;
        this.reloadResource(true);
    }

    public T load(boolean selfContained) {
        if (selfContained) {
            return this.loadConfigFromSelf(this.selfFile, this.fileName);
        }
        return this.loadConfigNoDefault(this.selfFile);
    }

    public void reload(boolean selfContained) {
        this.resource = this.load(selfContained);
    }

    public void syncMap() {
        for (String key : ((FlatFile)this.resource).keySet()) {
            Object obj = this.resource.get(key);
            if (obj == null) continue;
            this.getMap().put(key, obj);
        }
    }

    @Override
    public <O> O get(String key, Class<O> def) {
        try {
            O object = this.resource.get(key, def.newInstance());
            if (!def.isInstance(object)) {
                return null;
            }
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void continueReloadResource() {
        this.reload(this.selfContained);
        this.syncMap();
    }

    @Override
    public <V> void write(String key, V value) {
        this.resource.set(key, value);
    }

    @Override
    public <O> O getOrSetDefault(String key, O value) {
        return this.resource.getOrSetDefault(key, value);
    }

    @Override
    public void push() {
    }

    @Override
    public boolean exists() {
        return this.selfFile.exists();
    }

    public boolean empty() {
        return this.lineCount() <= 0;
    }

    public ConcurrentSkipListMap<Integer, String> lines() {
        try {
            Scanner reader = new Scanner(this.selfFile);
            ConcurrentSkipListMap<Integer, String> lines = new ConcurrentSkipListMap<Integer, String>();
            while (reader.hasNext()) {
                String s2 = reader.nextLine();
                lines.put(lines.size() + 1, s2);
            }
            return lines;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ConcurrentSkipListMap<Integer, String>();
        }
    }

    public int lineCount() {
        return this.lines().size();
    }

    public T loadConfigFromSelf(File file, String fileString) {
        if (!file.exists()) {
            try {
                this.parentDirectory.mkdirs();
                try (InputStream in = this.getResourceAsStream(fileString);){
                    assert (in != null);
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getResourceType().equals(Config.class)) {
            return (T)StorageUtils.fromFile(file).createConfig();
        }
        if (this.getResourceType().equals(Yaml.class)) {
            return (T)StorageUtils.fromFile(file).createYaml();
        }
        if (this.getResourceType().equals(Json.class)) {
            return (T)StorageUtils.fromFile(file).createJson();
        }
        if (this.getResourceType().equals(Toml.class)) {
            return (T)StorageUtils.fromFile(file).createToml();
        }
        return null;
    }

    public T loadConfigNoDefault(File file) {
        if (!file.exists()) {
            try {
                this.parentDirectory.mkdirs();
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.getResourceType().equals(Config.class)) {
            return (T)SimplixBuilder.fromFile(file).createConfig();
        }
        if (this.getResourceType().equals(Yaml.class)) {
            return (T)SimplixBuilder.fromFile(file).createYaml();
        }
        if (this.getResourceType().equals(Json.class)) {
            return (T)SimplixBuilder.fromFile(file).createJson();
        }
        if (this.getResourceType().equals(Toml.class)) {
            return (T)SimplixBuilder.fromFile(file).createToml();
        }
        return null;
    }

    @Override
    public void delete() {
        this.selfFile.delete();
    }

    @Override
    public ConcurrentSkipListSet<String> singleLayerKeySet() {
        return new ConcurrentSkipListSet<String>(((FlatFile)this.resource).singleLayerKeySet());
    }

    @Override
    public ConcurrentSkipListSet<String> singleLayerKeySet(String key) {
        return new ConcurrentSkipListSet<String>(this.resource.singleLayerKeySet(key));
    }

    @Override
    public <V> void updateSingle(String key, V value) {
        this.write(key, value);
    }

    @Override
    public <V> void updateMultiple(ConcurrentSkipListMap<String, V> values) {
        values.forEach(this::updateSingle);
    }

    @Generated
    public T getResource() {
        return this.resource;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public File getParentDirectory() {
        return this.parentDirectory;
    }

    @Generated
    public File getSelfFile() {
        return this.selfFile;
    }

    @Generated
    public boolean isSelfContained() {
        return this.selfContained;
    }

    @Generated
    public void setResource(T resource) {
        this.resource = resource;
    }
}

