/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.CloseEvents;
import io.lettuce.core.CommandListenerWriter;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.FutureSyncInvocationHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisConnectionStateListener;
import io.lettuce.core.api.AsyncCloseable;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandExpiryWriter;
import io.lettuce.core.protocol.CommandWrapper;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.protocol.TracedCommand;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.tracing.TraceContextProvider;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class RedisChannelHandler<K, V>
implements Closeable,
ConnectionFacade {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    private static final AtomicIntegerFieldUpdater<RedisChannelHandler> CLOSED = AtomicIntegerFieldUpdater.newUpdater(RedisChannelHandler.class, "closed");
    private static final int ST_OPEN = 0;
    private static final int ST_CLOSED = 1;
    private Duration timeout;
    private final ConnectionEvents connectionEvents = new ConnectionEvents();
    private CloseEvents closeEvents = new CloseEvents();
    private final RedisChannelWriter channelWriter;
    private final ClientResources clientResources;
    private final boolean tracingEnabled;
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile int closed = 0;
    private volatile boolean active = true;
    private volatile ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter writer, Duration timeout) {
        this.channelWriter = writer;
        this.clientResources = writer.getClientResources();
        this.tracingEnabled = this.clientResources.tracing().isEnabled();
        writer.setConnectionFacade(this);
        this.setTimeout(timeout);
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull((Object)listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public void setTimeout(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.timeout = timeout;
        RedisChannelWriter writer = this.channelWriter;
        if (writer instanceof CommandListenerWriter) {
            writer = ((CommandListenerWriter)this.channelWriter).getDelegate();
        }
        if (writer instanceof CommandExpiryWriter) {
            ((CommandExpiryWriter)writer).setTimeout(timeout);
        }
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.debugEnabled) {
            logger.debug("closeAsync()");
        }
        if (CLOSED.get(this) == 1) {
            logger.warn("Connection is already closed");
            return this.closeFuture;
        }
        if (CLOSED.compareAndSet(this, 0, 1)) {
            this.active = false;
            CompletableFuture<Void> future = this.channelWriter.closeAsync();
            future.whenComplete((v, t2) -> {
                this.closeEvents.fireEventClosed(this);
                this.closeEvents = new CloseEvents();
                if (t2 != null) {
                    this.closeFuture.completeExceptionally((Throwable)t2);
                } else {
                    this.closeFuture.complete((Void)v);
                }
            });
        } else {
            logger.warn("Connection is already closed (concurrently)");
        }
        return this.closeFuture;
    }

    protected <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", (Object)cmd);
        }
        if (this.tracingEnabled) {
            RedisCommand<K, V, T> commandToSend = cmd;
            TraceContextProvider provider = CommandWrapper.unwrap(cmd, TraceContextProvider.class);
            if (provider == null) {
                commandToSend = new TracedCommand<K, V, T>(cmd, this.clientResources.tracing().initialTraceContextProvider().getTraceContext());
            }
            return this.channelWriter.write(commandToSend);
        }
        return this.channelWriter.write(cmd);
    }

    protected Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        if (this.debugEnabled) {
            logger.debug("dispatching commands {}", (Object)commands);
        }
        if (this.tracingEnabled) {
            ArrayList withTracer = new ArrayList(commands.size());
            Iterator<RedisCommand<K, V, ?>> iterator = commands.iterator();
            while (iterator.hasNext()) {
                RedisCommand<K, V, ?> command;
                RedisCommand<K, V, ?> commandToUse = command = iterator.next();
                TraceContextProvider provider = CommandWrapper.unwrap(command, TraceContextProvider.class);
                if (provider == null) {
                    commandToUse = new TracedCommand(command, this.clientResources.tracing().initialTraceContextProvider().getTraceContext());
                }
                withTracer.add(commandToUse);
            }
            return this.channelWriter.write(withTracer);
        }
        return this.channelWriter.write(commands);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener((Object resource) -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    if (closeable instanceof AsyncCloseable) {
                        ((AsyncCloseable)((Object)closeable)).closeAsync();
                        continue;
                    }
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return CLOSED.get(this) == 1;
    }

    @Override
    public void activated() {
        this.active = true;
        CLOSED.set(this, 0);
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    @Override
    @Deprecated
    public void reset() {
        this.channelWriter.reset();
    }

    public ConnectionEvents getConnectionEvents() {
        return this.connectionEvents;
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h2 = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, (InvocationHandler)h2);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

