/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.Optional;

public class VSimArgs
implements CompositeArgument {
    private Optional<Long> count = Optional.empty();
    private Optional<Long> explorationFactor = Optional.empty();
    private Optional<String> filter = Optional.empty();
    private Optional<Long> filterEfficiency = Optional.empty();
    private Optional<Boolean> truth = Optional.empty();
    private Optional<Boolean> noThread = Optional.empty();

    public VSimArgs count(Long count) {
        LettuceAssert.isTrue(count > 0L, "Count must be greater than 0");
        this.count = Optional.of(count);
        return this;
    }

    public VSimArgs explorationFactor(Long explorationFactor) {
        LettuceAssert.isTrue(explorationFactor > 0L, "Exploration factor must be greater than 0");
        this.explorationFactor = Optional.of(explorationFactor);
        return this;
    }

    public VSimArgs filter(String filter) {
        LettuceAssert.notNull((Object)filter, "Filter must not be null");
        LettuceAssert.notEmpty((CharSequence)filter, "Filter must not be empty");
        this.filter = Optional.of(filter);
        return this;
    }

    public VSimArgs filterEfficiency(Long filterEfficiency) {
        LettuceAssert.isTrue(filterEfficiency >= 0L, "Filter efficiency must be greater than or equal to 0");
        this.filterEfficiency = Optional.of(filterEfficiency);
        return this;
    }

    public VSimArgs truth() {
        return this.truth(true);
    }

    public VSimArgs truth(boolean truth) {
        this.truth = Optional.of(truth);
        return this;
    }

    public VSimArgs noThread() {
        return this.noThread(true);
    }

    public VSimArgs noThread(boolean noThread) {
        this.noThread = Optional.of(noThread);
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        this.count.ifPresent(Long2 -> args.add(CommandKeyword.COUNT).add((long)Long2));
        this.explorationFactor.ifPresent(Long2 -> args.add(CommandKeyword.EF).add((long)Long2));
        this.filter.ifPresent(s2 -> args.add(CommandKeyword.FILTER).add((String)s2));
        this.filterEfficiency.ifPresent(Long2 -> args.add(CommandKeyword.FILTER_EF).add((long)Long2));
        if (this.truth.isPresent() && this.truth.get().booleanValue()) {
            args.add(CommandKeyword.TRUTH);
        }
        if (this.noThread.isPresent() && this.noThread.get().booleanValue()) {
            args.add(CommandKeyword.NOTHREAD);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static VSimArgs count(Long count) {
            return new VSimArgs().count(count);
        }

        public static VSimArgs explorationFactor(Long explorationFactor) {
            return new VSimArgs().explorationFactor(explorationFactor);
        }

        public static VSimArgs filter(String filter) {
            return new VSimArgs().filter(filter);
        }

        public static VSimArgs filterEfficiency(Long filterEfficiency) {
            return new VSimArgs().filterEfficiency(filterEfficiency);
        }

        public static VSimArgs truth() {
            return new VSimArgs().truth();
        }

        public static VSimArgs noThread() {
            return new VSimArgs().noThread();
        }
    }
}

