/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.support;

import io.lettuce.core.dynamic.support.ClassTypeInformation;
import io.lettuce.core.dynamic.support.ParentTypeAwareTypeInformation;
import io.lettuce.core.dynamic.support.TypeDiscoverer;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.dynamic.support.WildcardTypeInformation;
import io.lettuce.core.internal.LettuceStrings;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class ParametrizedTypeInformation<T>
extends ParentTypeAwareTypeInformation<T> {
    private final ParameterizedType type;
    private Boolean resolved;

    public ParametrizedTypeInformation(ParameterizedType type, TypeDiscoverer<?> parent, Map<TypeVariable<?>, Type> typeVariableMap) {
        super(type, parent, typeVariableMap);
        this.type = type;
    }

    @Override
    protected TypeInformation<?> doGetMapValueType() {
        Type[] arguments;
        if (Map.class.isAssignableFrom(this.getType()) && (arguments = this.type.getActualTypeArguments()).length > 1) {
            return this.createInfo(arguments[1]);
        }
        Class rawType = this.getType();
        HashSet<Type> supertypes = new HashSet<Type>();
        supertypes.add(rawType.getGenericSuperclass());
        supertypes.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type supertype : supertypes) {
            Class rawSuperType = this.resolveClass(supertype);
            if (!Map.class.isAssignableFrom(rawSuperType)) continue;
            ParameterizedType parameterizedSupertype = (ParameterizedType)supertype;
            Type[] arguments2 = parameterizedSupertype.getActualTypeArguments();
            return this.createInfo(arguments2[1]);
        }
        return super.doGetMapValueType();
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        ArrayList result = new ArrayList();
        for (Type argument : this.type.getActualTypeArguments()) {
            result.add(this.createInfo(argument));
        }
        return result;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        Class<?> rawTargetType;
        if (this.equals(target)) {
            return true;
        }
        Class rawType = this.getType();
        if (!rawType.isAssignableFrom(rawTargetType = target.getType())) {
            return false;
        }
        TypeInformation otherTypeInformation = rawType.equals(rawTargetType) ? target : target.getSuperTypeInformation(rawType);
        List<TypeInformation<?>> myParameters = this.getTypeArguments();
        List<TypeInformation<?>> typeParameters = otherTypeInformation.getTypeArguments();
        if (myParameters.size() != typeParameters.size()) {
            return false;
        }
        for (int i2 = 0; i2 < myParameters.size(); ++i2) {
            if (myParameters.get(i2) instanceof WildcardTypeInformation) {
                if (myParameters.get(i2).isAssignableFrom(typeParameters.get(i2))) continue;
                return false;
            }
            if (!myParameters.get(i2).getType().equals(typeParameters.get(i2).getType())) {
                return false;
            }
            if (myParameters.get(i2).isAssignableFrom(typeParameters.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected TypeInformation<?> doGetComponentType() {
        return this.createInfo(this.type.getActualTypeArguments()[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParametrizedTypeInformation)) {
            return false;
        }
        ParametrizedTypeInformation that = (ParametrizedTypeInformation)obj;
        if (this.isResolvedCompletely() && that.isResolvedCompletely()) {
            return this.type.equals(that.type);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.isResolvedCompletely() ? this.type.hashCode() : super.hashCode();
    }

    public String toString() {
        return String.format("%s<%s>", this.getType().getName(), LettuceStrings.collectionToDelimitedString(this.getTypeArguments(), ",", "", ""));
    }

    private boolean isResolvedCompletely() {
        if (this.resolved != null) {
            return this.resolved;
        }
        Type[] typeArguments = this.type.getActualTypeArguments();
        if (typeArguments.length == 0) {
            return this.cacheAndReturn(false);
        }
        for (Type typeArgument : typeArguments) {
            TypeInformation<?> info2 = this.createInfo(typeArgument);
            if (info2 instanceof ParametrizedTypeInformation && !((ParametrizedTypeInformation)info2).isResolvedCompletely()) {
                return this.cacheAndReturn(false);
            }
            if (info2 instanceof ClassTypeInformation) continue;
            return this.cacheAndReturn(false);
        }
        return this.cacheAndReturn(true);
    }

    private boolean cacheAndReturn(boolean resolved) {
        this.resolved = resolved;
        return resolved;
    }
}

