/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.base.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.command.CosmicCommand;
import singularity.command.context.CommandContext;
import singularity.configs.given.MainMessagesHandler;
import singularity.modules.ModuleLike;
import singularity.modules.ModuleManager;
import singularity.utils.MessageUtils;

public class ModulesCommand
extends CosmicCommand {
    private final String messageResultReapplyAll = this.getCommandResource().getOrSetDefault("messages.result.reapply.all", "&eRe-applied all modules&8!");
    private final String messageResultReapplyOne;
    private final String messageResultReloadAll = this.getCommandResource().getOrSetDefault("messages.result.reload.all", "&eReloaded all modules&8!");
    private final String messageResultReloadOne;
    private final String messageResultLoadAll = this.getCommandResource().getOrSetDefault("messages.result.load.all", "&eLoaded all modules&8!");
    private final String messageResultLoadOne;
    private final String messageResultUnloadAll = this.getCommandResource().getOrSetDefault("messages.result.unload.all", "&eUnloaded all modules&8!");
    private final String messageResultUnloadOne;
    private final String messageResultEnableAll = this.getCommandResource().getOrSetDefault("messages.result.enable.all", "&eEnabled all modules&8!");
    private final String messageResultEnableOne;
    private final String messageResultDisableAll = this.getCommandResource().getOrSetDefault("messages.result.disable.all", "&eDisabled all modules&8!");
    private final String messageResultDisableOne;
    private final String messageResultListAll = this.getCommandResource().getOrSetDefault("messages.result.list.all", "&eModules: &8%streamline_modules_colorized%&8!");

    public ModulesCommand() {
        super("streamline-base", "streamlinemodules", "streamline.command.streamlinemodules.default", "module", "modules", "pmodules", "slm");
        this.messageResultReapplyOne = this.getCommandResource().getOrSetDefault("messages.result.reapply.one", "&eRe-applied module &7'&c%this_identifier%&7'&8!");
        this.messageResultReloadOne = this.getCommandResource().getOrSetDefault("messages.result.reload.one", "&eReloaded module &7'&c%this_identifier%&7'&8!");
        this.messageResultLoadOne = this.getCommandResource().getOrSetDefault("messages.result.load.one", "&eLoaded module &7'&c%this_identifier%&7'&8!");
        this.messageResultUnloadOne = this.getCommandResource().getOrSetDefault("messages.result.unload.one", "&eUnloaded module &7'&c%this_identifier%&7'&8!");
        this.messageResultEnableOne = this.getCommandResource().getOrSetDefault("messages.result.enable.one", "&eEnabled module &7'&c%this_identifier%&7'&8!");
        this.messageResultDisableOne = this.getCommandResource().getOrSetDefault("messages.result.disable.one", "&eDisabled module &7'&c%this_identifier%&7'&8!");
    }

    @Override
    public void run(CommandContext<CosmicCommand> context) {
        if (context.getArgCount() < 1) {
            context.sendMessage(MainMessagesHandler.MESSAGES.INVALID.ARGUMENTS_TOO_FEW.get());
            return;
        }
        switch (context.getStringArg(0).toLowerCase(Locale.ROOT)) {
            case "reapply": {
                if (context.getArgCount() == 1) {
                    ModuleManager.getLoadedModules().forEach((s2, module) -> ModuleManager.unregisterModule(module));
                    ModuleManager.registerExternalModules();
                    context.sendMessage(this.messageResultReapplyAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    ModuleLike module = ModuleManager.getModule(a);
                    ModuleManager.reapplyModule(module.getIdentifier());
                    context.sendMessage(this.messageResultReapplyOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            case "reload": {
                if (context.getArgCount() == 1) {
                    ModuleManager.restartModules();
                    context.sendMessage(this.messageResultReloadAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    if (!ModuleManager.hasModule(a)) {
                        return;
                    }
                    ModuleManager.getModule(a).restart();
                    context.sendMessage(this.messageResultReloadOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            case "load": {
                if (context.getArgCount() == 1) {
                    ModuleManager.registerExternalModules();
                    context.sendMessage(this.messageResultLoadAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    if (ModuleManager.hasModule(a)) {
                        return;
                    }
                    ModuleManager.registerExternalModule(a);
                    context.sendMessage(this.messageResultLoadOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            case "unload": {
                if (context.getArgCount() == 1) {
                    ModuleManager.getLoadedModules().forEach(ModuleManager::unregisterModule);
                    context.sendMessage(this.messageResultUnloadAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    if (!ModuleManager.hasModule(a)) {
                        return;
                    }
                    ModuleManager.unregisterModule(ModuleManager.getModule(a));
                    context.sendMessage(this.messageResultUnloadOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            case "enable": {
                if (context.getArgCount() == 1) {
                    ModuleManager.getLoadedModules().forEach((s2, module) -> module.start());
                    context.sendMessage(this.messageResultEnableAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    if (!ModuleManager.hasModule(a)) {
                        return;
                    }
                    ModuleManager.getModule(a).start();
                    context.sendMessage(this.messageResultEnableOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            case "disable": {
                if (context.getArgCount() == 1) {
                    ModuleManager.getLoadedModules().forEach((s2, module) -> module.stop());
                    context.sendMessage(this.messageResultDisableAll);
                    break;
                }
                Arrays.stream(MessageUtils.argsMinus(context.getArgsArray(), 0)).forEach(a -> {
                    if (!ModuleManager.hasModule(a)) {
                        return;
                    }
                    ModuleManager.getModule(a).stop();
                    context.sendMessage(this.messageResultDisableOne.replace("%this_identifier%", (CharSequence)a));
                });
                break;
            }
            default: {
                context.sendMessage(this.getWithOther(context.getSender(), this.messageResultListAll, context.getSender()));
            }
        }
    }

    @Override
    public ConcurrentSkipListSet<String> doTabComplete(CommandContext<CosmicCommand> context) {
        if (context.getArgCount() <= 1) {
            return new ConcurrentSkipListSet<String>(List.of("reapply", "reload", "load", "unload", "enable", "disable", "list"));
        }
        if (context.getArgCount() == 2) {
            if (context.getStringArg(0).equalsIgnoreCase("reapply") || context.getStringArg(0).equalsIgnoreCase("reload") || context.getStringArg(0).equalsIgnoreCase("unload") || context.getStringArg(0).equalsIgnoreCase("enable") || context.getStringArg(0).equalsIgnoreCase("disable")) {
                return ModuleManager.getOnlyMalleableModuleIdentifiers();
            }
            if (context.getStringArg(0).equalsIgnoreCase("load")) {
                return ModuleManager.getUnloadedExternalModuleIdentifiers();
            }
        }
        return new ConcurrentSkipListSet<String>();
    }
}

