/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.base;

import com.google.inject.Inject;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.File;
import java.nio.file.Path;
import net.streamline.metrics.Metrics;
import net.streamline.platform.BasePlugin;
import org.slf4j.Logger;
import singularity.modules.ModuleManager;

public class StreamlineVelocity
extends BasePlugin {
    @Inject
    public StreamlineVelocity(ProxyServer server, Logger logger, Metrics.Factory metricsFactory) {
        super(server, logger, StreamlineVelocity.getOwnFolder(), metricsFactory);
    }

    public static File getOwnFolder() {
        return new File(StreamlineVelocity.getPluginsDirectory(), "StreamlineCore");
    }

    public static File getPluginsDirectory() {
        File file = StreamlineVelocity.getSystemFile();
        File[] files = file.listFiles();
        if (files == null) {
            return null;
        }
        File pluginDirectory = null;
        for (File f : files) {
            if (!f.getName().equals("plugins")) continue;
            pluginDirectory = f;
            break;
        }
        if (pluginDirectory == null) {
            files = (file = file.getParentFile()).listFiles();
            if (files == null) {
                return null;
            }
            for (File f : files) {
                if (!f.getName().equals("plugins")) continue;
                pluginDirectory = f;
                break;
            }
        }
        return pluginDirectory;
    }

    public static Path getSystemPath() {
        return Path.of(System.getProperty("user.dir"), new String[0]);
    }

    public static File getSystemFile() {
        return StreamlineVelocity.getSystemPath().toFile();
    }

    public static String getStreamlineName() {
        String name = "${name}";
        if (name.startsWith("$")) {
            name = "StreamlineCore";
        }
        return name;
    }

    public static String getStreamlineVersion() {
        String version = "${version}";
        if (version.startsWith("$")) {
            version = "2.5.2.0";
        }
        return version;
    }

    @Override
    public void enable() {
        try {
            ModuleManager.registerExternalModules();
            ModuleManager.startModules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Metrics metrics = this.getMetricsFactory().make(this, 26274);
        metrics.addCustomChart(new Metrics.SimplePie("plugin_version", () -> (String)((PluginContainer)this.getProxy().getPluginManager().getPlugin("streamlinecore").get()).getDescription().getVersion().get()));
        metrics.addCustomChart(new Metrics.SimplePie("modules_loaded_count", () -> String.valueOf(ModuleManager.getLoadedModules().size())));
        metrics.addCustomChart(new Metrics.SimplePie("modules_enabled_count", () -> String.valueOf(ModuleManager.getEnabledModules().size())));
        metrics.addCustomChart(new Metrics.SingleLineChart("total_modules_loaded", () -> ModuleManager.getLoadedModules().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("total_modules_enabled", () -> ModuleManager.getEnabledModules().size()));
    }

    @Override
    public void disable() {
        ModuleManager.stopModules();
    }

    @Override
    public void load() {
    }
}

