/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import gg.drak.thebase.events.BaseEventHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.streamline.api.SLAPI;
import net.streamline.api.base.module.BaseModule;
import net.streamline.base.StreamlineVelocity;
import net.streamline.base.runnables.PlayerChecker;
import net.streamline.metrics.Metrics;
import net.streamline.platform.Messenger;
import net.streamline.platform.commands.ProperCommand;
import net.streamline.platform.listeners.PlatformListener;
import net.streamline.platform.messaging.ProxyPluginMessenger;
import net.streamline.platform.savables.ConsoleHolder;
import net.streamline.platform.savables.PlayerInterface;
import net.streamline.platform.savables.UserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import singularity.Singularity;
import singularity.command.CosmicCommand;
import singularity.data.players.CosmicPlayer;
import singularity.data.uuid.UuidInfo;
import singularity.data.uuid.UuidManager;
import singularity.events.CosmicEvent;
import singularity.events.server.ServerStopEvent;
import singularity.interfaces.IProperEvent;
import singularity.interfaces.ISingularityExtension;
import singularity.objects.CosmicResourcePack;
import singularity.scheduler.TaskManager;
import singularity.utils.MessageUtils;
import singularity.utils.StorageUtils;
import singularity.utils.UserUtils;

public abstract class BasePlugin
implements ISingularityExtension {
    private final ISingularityExtension.PlatformType platformType = ISingularityExtension.PlatformType.VELOCITY;
    private final ISingularityExtension.ServerType serverType = ISingularityExtension.ServerType.PROXY;
    private String name;
    private String version;
    private static BasePlugin instance;
    private SLAPI<CommandSource, Player, BasePlugin, UserManager, Messenger> slapi;
    private UserManager userManager;
    private Messenger messenger;
    private ConsoleHolder consoleHolder;
    private PlayerInterface playerInterface;
    private CosmicResourcePack resourcePack;
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataDirectory;
    private final File dataFolder;
    private final Metrics.Factory metricsFactory;
    private static PlayerChecker playerChecker;

    public BasePlugin(ProxyServer server, Logger logger, File dataFolder, Metrics.Factory metricsFactory) {
        File parentFile;
        File[] files;
        this.proxy = server;
        this.logger = logger;
        this.dataDirectory = dataFolder.toPath();
        this.dataFolder = dataFolder;
        this.metricsFactory = metricsFactory;
        Path parentPath = this.dataDirectory.getParent();
        if (parentPath != null && (files = (parentFile = new File(parentPath.toString())).listFiles(f -> {
            if (!f.isDirectory()) {
                return false;
            }
            if (f.getName().equals("StreamlineAPI")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Spigot")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Bungee")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Velocity")) {
                return true;
            }
            return f.getName().equals("streamlinecore");
        })) != null) {
            Arrays.stream(files).forEach(file -> file.renameTo(new File(parentPath.toString(), StreamlineVelocity.getStreamlineName())));
        }
        this.onLoad();
    }

    public void onLoad() {
        File parentFile;
        File[] files;
        instance = this;
        this.setupProperties();
        String parentPath = this.getDataFolder().getParent();
        if (parentPath != null && (files = (parentFile = new File(parentPath)).listFiles(f -> {
            if (!f.isDirectory()) {
                return false;
            }
            if (f.getName().equals("StreamlineAPI")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Spigot")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Bungee")) {
                return true;
            }
            if (f.getName().equals("StreamlineCore-Velocity")) {
                return true;
            }
            return f.getName().equals("streamlinecore");
        })) != null) {
            Arrays.stream(files).forEach(file -> file.renameTo(new File(parentPath, this.name)));
        }
        this.load();
    }

    public void setupProperties() {
        ConcurrentSkipListMap<String, String> properties = StorageUtils.readProperties();
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("name")) {
                this.name = value;
            }
            if (!key.equals("version")) continue;
            this.version = value;
        }
    }

    @Subscribe
    public void onEnable(ProxyInitializeEvent event) {
        this.userManager = new UserManager();
        this.messenger = new Messenger();
        this.consoleHolder = new ConsoleHolder();
        this.playerInterface = new PlayerInterface();
        this.slapi = new SLAPI<CommandSource, Player, BasePlugin, UserManager, Messenger>(this.getName(), this, this.getUserManager(), this.getMessenger(), this.getConsoleHolder(), this.getPlayerInterface(), BaseModule::new);
        this.getSlapi().setProxyMessenger(new ProxyPluginMessenger());
        BasePlugin.registerListener(new PlatformListener());
        TaskManager.init();
        this.getProxy().getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)SLAPI.getApiChannel())});
        playerChecker = new PlayerChecker();
        this.enable();
    }

    @Subscribe
    public void onDisable(ProxyShutdownEvent event) {
        Singularity.getTpTicketFlusher().cancel();
        Singularity.getTpTicketPuller().cancel();
        UserUtils.syncAllUsers();
        UuidManager.getUuids().forEach(UuidInfo::save);
        this.getProxy().getChannelRegistrar().unregister(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)SLAPI.getApiChannel())});
        this.disable();
        this.fireStopEvent();
        TaskManager.stop();
    }

    public void fireStopEvent() {
        ServerStopEvent e = (ServerStopEvent)new ServerStopEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    public abstract void enable();

    public abstract void disable();

    public abstract void load();

    public static void registerListener(Object listener) {
        BasePlugin.getInstance().getProxy().getEventManager().register((Object)BasePlugin.getInstance(), listener);
    }

    @Override
    @NotNull
    public ConcurrentSkipListSet<CosmicPlayer> getOnlinePlayers() {
        ConcurrentSkipListSet<CosmicPlayer> players = new ConcurrentSkipListSet<CosmicPlayer>();
        for (Player player : BasePlugin.onlinePlayers()) {
            CosmicPlayer cosmicPlayer = this.getUserManager().getOrCreatePlayer(player).orElse(null);
            if (cosmicPlayer == null) continue;
            players.add(cosmicPlayer);
        }
        return players;
    }

    @Override
    public ProperCommand createCommand(CosmicCommand command) {
        return new ProperCommand(command);
    }

    @Override
    public int getMaxPlayers() {
        return BasePlugin.getInstance().getProxy().getConfiguration().getShowMaxPlayers();
    }

    @Override
    public ConcurrentSkipListSet<String> getOnlinePlayerNames() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        this.getOnlinePlayers().forEach(a -> r.add(a.getCurrentName()));
        return r;
    }

    @Override
    public long getConnectionThrottle() {
        return BasePlugin.getInstance().getProxy().getConfiguration().getCompressionThreshold();
    }

    public static List<Player> onlinePlayers() {
        return new ArrayList<Player>(BasePlugin.getInstance().getProxy().getAllPlayers());
    }

    public static List<Player> playersOnServer(String serverName) {
        Optional serverOpt = BasePlugin.getInstance().getProxy().getServer(serverName);
        return serverOpt.map(registeredServer -> new ArrayList(registeredServer.getPlayersConnected())).orElseGet(ArrayList::new);
    }

    public static Player getPlayer(String uuid) {
        for (Player player : BasePlugin.onlinePlayers()) {
            if (!player.getUniqueId().toString().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public static Optional<Player> getPlayerByName(String name) {
        return BasePlugin.getInstance().getProxy().getPlayer(name);
    }

    @Nullable
    public static Player getPlayerExact(@NotNull String name) {
        if (BasePlugin.getPlayerByName(name).isEmpty()) {
            return null;
        }
        return BasePlugin.getPlayerByName(name).get();
    }

    @NotNull
    public static List<Player> matchPlayer(@NotNull String name) {
        Player player = BasePlugin.getPlayerExact(name);
        if (player == null) {
            return new ArrayList<Player>();
        }
        return List.of(player);
    }

    @Nullable
    public static Player getPlayer(@NotNull UUID id) {
        return BasePlugin.getPlayer(id.toString());
    }

    public static Player getPlayer(CommandSource sender) {
        Optional player = BasePlugin.getInstance().getProxy().getPlayer(BasePlugin.getInstance().getUserManager().getUsername(sender));
        return player.orElse(null);
    }

    @Override
    public boolean getOnlineMode() {
        return BasePlugin.getInstance().getProxy().getConfiguration().isOnlineMode();
    }

    @Override
    public void shutdown() {
        BasePlugin.getInstance().getProxy().shutdown();
    }

    @Override
    public int broadcast(@NotNull String message, @NotNull String permission) {
        int people = 0;
        for (Player player : BasePlugin.onlinePlayers()) {
            if (!player.hasPermission(permission)) continue;
            this.getMessenger().sendMessage((CommandSource)player, message);
            ++people;
        }
        return people;
    }

    @Override
    public boolean serverHasPlugin(String plugin) {
        return BasePlugin.getInstance().getProxy().getPluginManager().getPlugin(plugin).isPresent();
    }

    @Override
    public boolean equalsAnyServer(String servername) {
        return this.getServerNames().contains(servername);
    }

    @Override
    public void fireEvent(IProperEvent<?> event) {
        if (!(event.getEvent() instanceof CompletableFuture)) {
            return;
        }
        CompletableFuture e = (CompletableFuture)event.getEvent();
        BasePlugin.getInstance().getProxy().getEventManager().fire((Object)e).join();
    }

    @Override
    public void fireEvent(CosmicEvent event) {
        this.fireEvent(event, true);
    }

    @Override
    public void fireEvent(CosmicEvent event, boolean async) {
        try {
            BaseEventHandler.fireEvent(event);
        }
        catch (Exception e) {
            this.handleMisSync(event, async);
        }
    }

    @Override
    public boolean isOfflineMode() {
        return !BasePlugin.getInstance().getProxy().getConfiguration().isOnlineMode();
    }

    @Override
    public void handleMisSync(CosmicEvent event, boolean async) {
        BaseEventHandler.fireEvent(event);
    }

    @Override
    public ConcurrentSkipListSet<String> getServerNames() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        BasePlugin.getInstance().getProxy().getAllServers().forEach(a -> r.add(a.getServerInfo().getName()));
        return r;
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, CosmicPlayer player) {
        Player p = BasePlugin.getPlayer(player.getUuid());
        this.sendResourcePack(resourcePack, p);
    }

    @Override
    public void sendResourcePack(CosmicResourcePack resourcePack, String uuid) {
        Player p = BasePlugin.getPlayer(uuid);
        this.sendResourcePack(resourcePack, p);
    }

    public void sendResourcePack(CosmicResourcePack resourcePack, Player player) {
        if (player == null) {
            return;
        }
        try {
            ResourcePackInfo.Builder infoBuilder = BasePlugin.getInstance().getProxy().createResourcePackBuilder(resourcePack.getUrl()).setShouldForce(resourcePack.isForce());
            if (resourcePack.getHash().length > 0) {
                infoBuilder.setHash(resourcePack.getHash());
            }
            if (!resourcePack.getPrompt().isEmpty()) {
                infoBuilder.setPrompt(this.getMessenger().codedText(resourcePack.getPrompt()));
            }
            player.sendResourcePackOffer(infoBuilder.build());
        }
        catch (Exception e) {
            MessageUtils.logWarning("Sent '" + player.getUsername() + "' a resourcepack, but it returned null! This is probably due to an incorrect link to the pack.");
        }
    }

    @Override
    public ClassLoader getMainClassLoader() {
        return this.getProxy().getClass().getClassLoader();
    }

    public static ConcurrentSkipListMap<String, Player> getPlayersByUUID() {
        ConcurrentSkipListMap<String, Player> map = new ConcurrentSkipListMap<String, Player>();
        for (Player player : BasePlugin.getInstance().getProxy().getAllPlayers()) {
            map.put(player.getUniqueId().toString(), player);
        }
        return map;
    }

    @Override
    public java.util.logging.Logger getLoggerLogger() {
        return null;
    }

    @Override
    public Logger getSLFLogger() {
        return this.getLogger();
    }

    @Override
    public ISingularityExtension.PlatformType getPlatformType() {
        return this.platformType;
    }

    @Override
    public ISingularityExtension.ServerType getServerType() {
        return this.serverType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public static BasePlugin getInstance() {
        return instance;
    }

    public SLAPI<CommandSource, Player, BasePlugin, UserManager, Messenger> getSlapi() {
        return this.slapi;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public ConsoleHolder getConsoleHolder() {
        return this.consoleHolder;
    }

    public PlayerInterface getPlayerInterface() {
        return this.playerInterface;
    }

    public CosmicResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public void setResourcePack(CosmicResourcePack resourcePack) {
        this.resourcePack = resourcePack;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public static PlayerChecker getPlayerChecker() {
        return playerChecker;
    }

    public static void setPlayerChecker(PlayerChecker playerChecker) {
        BasePlugin.playerChecker = playerChecker;
    }
}

