/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.commands;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import net.streamline.base.StreamlineVelocity;
import net.streamline.platform.Messenger;
import net.streamline.platform.savables.UserManager;
import singularity.command.CosmicCommand;
import singularity.data.console.CosmicSender;
import singularity.interfaces.IProperCommand;
import singularity.utils.MessageUtils;

public class ProperCommand
implements SimpleCommand,
IProperCommand {
    private final CosmicCommand parent;
    private final String base;
    private final String permission;
    private final String[] aliases;

    public ProperCommand(CosmicCommand parent) {
        this.parent = parent;
        this.base = parent.getBase();
        this.permission = parent.getPermission();
        this.aliases = parent.getAliases();
    }

    public void execute(SimpleCommand.Invocation invocation) {
        try {
            CosmicSender s2 = UserManager.getInstance().getOrCreateSender(invocation.source()).orElse(null);
            if (s2 == null) {
                MessageUtils.logWarning("Command execution failed: Sender is null.");
                return;
            }
            this.parent.baseRun(s2, (String[])invocation.arguments());
        }
        catch (Throwable e) {
            Messenger.getInstance().sendMessage(invocation.source(), "&cAn error occurred while executing the command &7'&e" + invocation.alias() + "&7'&8. &cPlease tell an admin to check the console.");
            MessageUtils.logWarning("An error occurred while executing command '" + this.base + "': " + e.getMessage());
            e.printStackTrace();
        }
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        try {
            CosmicSender s2;
            String[] args = (String[])invocation.arguments();
            if (args.length < 1) {
                args = new String[]{""};
            }
            if ((s2 = (CosmicSender)UserManager.getInstance().getOrCreateSender(invocation.source()).orElse(null)) == null) {
                MessageUtils.logWarning("Command suggestion failed: Sender is null.");
                return CompletableFuture.completedFuture(new ArrayList());
            }
            ConcurrentSkipListSet<String> r = this.parent.baseTabComplete(s2, (String[])invocation.arguments());
            return CompletableFuture.completedFuture(r == null ? new ArrayList() : new ArrayList<String>(MessageUtils.getCompletion(r, args[args.length - 1])));
        }
        catch (Throwable e) {
            MessageUtils.logWarning("An error occurred while suggesting command '" + this.base + "': " + e.getMessage());
            e.printStackTrace();
            return CompletableFuture.completedFuture(new ArrayList());
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission(this.permission);
    }

    @Override
    public void register() {
        StreamlineVelocity.getInstance().getProxy().getCommandManager().register(this.getMeta(), (Command)this);
    }

    @Override
    public void unregister() {
        StreamlineVelocity.getInstance().getProxy().getCommandManager().unregister(this.getMeta());
    }

    public CommandMeta getMeta() {
        return StreamlineVelocity.getInstance().getProxy().getCommandManager().metaBuilder(this.getParent().getBase()).plugin((Object)StreamlineVelocity.getInstance()).aliases(this.getParent().getAliases()).build();
    }

    public CosmicCommand getParent() {
        return this.parent;
    }

    public String getBase() {
        return this.base;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }
}

