/*
 * Decompiled with CFR 0.152.
 */
package singularity.board;

import java.util.concurrent.ConcurrentSkipListSet;
import singularity.board.data.BoardData;

public class MessageBoard<T> {
    private final T of;
    private ConcurrentSkipListSet<BoardData> data;

    public MessageBoard(T of, ConcurrentSkipListSet<BoardData> data) {
        this.of = of;
        this.data = data;
    }

    public MessageBoard(T of) {
        this(of, new ConcurrentSkipListSet<BoardData>());
    }

    public MessageBoard<T> withData(ConcurrentSkipListSet<BoardData> data) {
        this.data = data;
        return this;
    }

    public void unpost(String identifier) {
        this.data.removeIf(data -> data.getSender().getIdentifier().equals(identifier));
    }

    public void unpost(Class<?> clazz) {
        this.data.removeIf(data -> data.getSender().getOf().getClass().equals(clazz));
    }

    public void unpost(BoardData data) {
        this.unpost(data.getIdentifier());
    }

    public void post(BoardData data) {
        this.unpost(data);
        this.data.add(data);
    }

    public T getOf() {
        return this.of;
    }

    public ConcurrentSkipListSet<BoardData> getData() {
        return this.data;
    }

    public void setData(ConcurrentSkipListSet<BoardData> data) {
        this.data = data;
    }
}

