/*
 * Decompiled with CFR 0.152.
 */
package singularity.command;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import singularity.Singularity;
import singularity.command.CommandMessageBuilder;
import singularity.configs.given.GivenConfigs;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.modules.ModuleUtils;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class CommandExecution {
    private String senderValue;
    private String command;

    public CommandExecution(String senderValue, String command) {
        this.setSenderValue(senderValue);
        this.setCommand(command);
    }

    public Optional<CosmicSender> getSender() {
        if (this.senderValue == null) {
            return Optional.empty();
        }
        if (this.senderValue.equals(GivenConfigs.getMainConfig().getConsoleDiscriminator())) {
            return Optional.of(UserUtils.getConsole());
        }
        if (this.senderValue.startsWith("@")) {
            String thing = this.senderValue.substring(1);
            String[] split = thing.split(":", 2);
            if (split.length == 2) {
                String classifier = split[0];
                if (classifier.equals("n")) {
                    String name = split[1];
                    return UserUtils.getOrCreateSenderByName(name);
                }
                if (classifier.equals("u")) {
                    return UserUtils.getOrCreateSender(split[1]);
                }
                return UserUtils.getOrCreateSenderByName(split[1]);
            }
            if (split[0].equals("c")) {
                return Optional.of(UserUtils.getConsole());
            }
            return UserUtils.getOrCreateSenderByName(split[0]);
        }
        return UserUtils.getOrCreateSenderByName(this.senderValue);
    }

    public void execute(String serverInput) {
        if (serverInput == null) {
            this.executeHere();
        } else if (serverInput.equals("HERE") || Singularity.isProxy() && (serverInput.equals("PROXY") || serverInput.equals("--null")) || serverInput.equals(GivenConfigs.getServerName())) {
            this.executeHere();
        } else {
            this.executeServer(serverInput);
        }
    }

    public void executeMayFail() {
        this.executeHere();
    }

    public void executeHere() {
        Optional<CosmicSender> optional = this.getSender();
        if (optional.isEmpty()) {
            return;
        }
        CosmicSender s2 = optional.get();
        if (s2.isConsole()) {
            MessageUtils.logDebug("Executing command " + this.getCommand() + " as " + this.getSenderValue() + " on console.");
            ModuleUtils.getConsole().runCommand(this.getCommand());
        } else {
            MessageUtils.logDebug("Executing command " + this.getCommand() + " as " + this.getSenderValue() + " on " + s2.getCurrentName() + ".");
            s2.runCommand(this.getCommand());
        }
    }

    public void executeServer(String server) {
        CosmicPlayer player = null;
        if (Singularity.isProxy()) {
            try {
                player = UserUtils.getPlayersOn(server).first();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            AtomicReference ref = new AtomicReference();
            UserUtils.getOnlinePlayers().forEach((s2, p) -> {
                if (ref.get() != null) {
                    return;
                }
                if (p.isOnline()) {
                    ref.set(p);
                }
            });
            player = (CosmicPlayer)ref.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (player == null) {
            MessageUtils.logDebug("No player found on server " + server + " to execute command " + this.getCommand() + " as " + this.getSenderValue() + ".");
            return;
        }
        CommandMessageBuilder.build(player, server, this).send();
    }

    public String getSenderValue() {
        return this.senderValue;
    }

    public String getCommand() {
        return this.command;
    }

    public void setSenderValue(String senderValue) {
        this.senderValue = senderValue;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

