/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import singularity.Singularity;
import singularity.database.ConnectorSet;
import singularity.database.DatabaseType;

public class DatabaseConfigHandler
extends SimpleConfiguration {
    public DatabaseConfigHandler() {
        super("database-config.yml", Singularity.getInstance(), true);
    }

    @Override
    public void init() {
        this.getDatabaseHost();
        this.getDatabasePort();
        this.getDatabaseUsername();
        this.getDatabasePassword();
        this.getDatabaseTablePrefix();
        this.getDatabaseName();
        this.getDatabaseType();
        this.getSqliteFileName();
    }

    public String getDatabaseHost() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("host", "localhost");
    }

    public int getDatabasePort() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("port", Integer.valueOf(3306));
    }

    public String getDatabaseUsername() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("username", "root");
    }

    public String getDatabasePassword() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("password", "password");
    }

    public String getDatabaseTablePrefix() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("table-prefix", "sl_");
    }

    public String getDatabaseName() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("database", "streamline");
    }

    public DatabaseType getDatabaseType() {
        this.reloadResource();
        return DatabaseType.valueOf(((Config)this.getResource()).getOrSetDefault("type", DatabaseType.SQLITE.name()));
    }

    public String getSqliteFileName() {
        this.reloadResource();
        return ((Config)this.getResource()).getOrSetDefault("sqlite-file-name", "streamline.db");
    }

    public ConnectorSet getConnectorSet() {
        return new ConnectorSet(this.getDatabaseType(), this.getDatabaseHost(), this.getDatabasePort(), this.getDatabaseName(), this.getDatabaseUsername(), this.getDatabasePassword(), this.getDatabaseTablePrefix(), this.getSqliteFileName());
    }
}

