/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players.location;

import org.jetbrains.annotations.NotNull;
import singularity.Singularity;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.BlockPosition;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.data.server.CosmicServer;

public class CosmicLocation
implements Comparable<CosmicLocation> {
    private CosmicServer server;
    private PlayerWorld world;
    private WorldPosition position;
    private PlayerRotation rotation;

    public CosmicLocation(CosmicServer server, PlayerWorld world, WorldPosition position, PlayerRotation rotation) {
        this.server = server;
        this.world = world;
        this.position = position;
        this.rotation = rotation;
    }

    public CosmicLocation(CosmicPlayer player) {
        this(new CosmicServer(""), new PlayerWorld("--null"), new WorldPosition(0.0, 0.0, 0.0), new PlayerRotation());
    }

    @Override
    public int compareTo(@NotNull CosmicLocation o) {
        if (this.world.compareTo(o.world) != 0) {
            return this.world.compareTo(o.world);
        }
        if (this.position.compareTo(o.position) != 0) {
            return this.position.compareTo(o.position);
        }
        return this.rotation.getYaw() == o.rotation.getYaw() && this.rotation.getPitch() == o.rotation.getPitch() ? 0 : 1;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public double getZ() {
        return this.position.getZ();
    }

    public float getYaw() {
        return this.rotation.getYaw();
    }

    public float getPitch() {
        return this.rotation.getPitch();
    }

    public BlockPosition asBlockPosition() {
        return this.getPosition().asBlockPosition();
    }

    public int getBlockX() {
        return this.asBlockPosition().getX();
    }

    public int getBlockY() {
        return this.asBlockPosition().getY();
    }

    public int getBlockZ() {
        return this.asBlockPosition().getZ();
    }

    public String getWorldName() {
        return this.world.getIdentifier();
    }

    public String getServerName() {
        return this.getServer().getIdentifier();
    }

    public CosmicLocation setX(double x) {
        this.position.setX(x);
        return this;
    }

    public CosmicLocation setY(double y) {
        this.position.setY(y);
        return this;
    }

    public CosmicLocation setZ(double z) {
        this.position.setZ(z);
        return this;
    }

    public CosmicLocation setYaw(float yaw) {
        this.rotation.setYaw(yaw);
        return this;
    }

    public CosmicLocation setPitch(float pitch) {
        this.rotation.setPitch(pitch);
        return this;
    }

    public CosmicLocation setWorldName(String worldName) {
        this.world = new PlayerWorld(worldName);
        return this;
    }

    public CosmicLocation setServerName(String serverName) {
        this.server = new CosmicServer(serverName);
        return this;
    }

    public String asString() {
        return "[server=" + this.getServerName() + ",world=" + this.getWorldName() + ",position={x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + "},rotation={yaw=" + this.getYaw() + ",pitch=" + this.getPitch() + "}]";
    }

    public void teleport(CosmicPlayer otherPlayer) {
        Singularity.getInstance().getUserManager().teleport(otherPlayer, this);
    }

    public double distance(CosmicLocation other) {
        return Math.sqrt(Math.pow(this.getX() - other.getX(), 2.0) + Math.pow(this.getY() - other.getY(), 2.0) + Math.pow(this.getZ() - other.getZ(), 2.0));
    }

    public CosmicServer getServer() {
        return this.server;
    }

    public PlayerWorld getWorld() {
        return this.world;
    }

    public WorldPosition getPosition() {
        return this.position;
    }

    public PlayerRotation getRotation() {
        return this.rotation;
    }

    public void setServer(CosmicServer server) {
        this.server = server;
    }

    public void setWorld(PlayerWorld world) {
        this.world = world;
    }

    public void setPosition(WorldPosition position) {
        this.position = position;
    }

    public void setRotation(PlayerRotation rotation) {
        this.rotation = rotation;
    }
}

