/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.update;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.Singularity;
import singularity.data.update.UpdateType;
import singularity.database.servers.UpdateInfo;
import singularity.utils.MessageUtils;

public class UpdateManager {
    private static ConcurrentSkipListSet<UpdateType<?>> loadedUpdateTypes = new ConcurrentSkipListSet();

    public static void load(UpdateType<?> updateType) {
        if (UpdateManager.isLoaded(updateType.getIdentifier())) {
            UpdateManager.unload(updateType);
        }
        loadedUpdateTypes.add(updateType);
    }

    public static void unload(String identifier) {
        MessageUtils.logInfo("Unloading update type: " + identifier);
        loadedUpdateTypes.removeIf(updateType -> updateType.getIdentifier().equals(identifier));
    }

    public static void unload(UpdateType<?> updateType) {
        UpdateManager.unload(updateType.getIdentifier());
    }

    public static Optional<UpdateType<?>> get(String identifier) {
        return loadedUpdateTypes.stream().filter(updateType -> updateType.getIdentifier().equals(identifier)).findFirst();
    }

    public static boolean isLoaded(String identifier) {
        return UpdateManager.get(identifier).isPresent();
    }

    public static boolean isLoaded(UpdateType<?> updateType) {
        return UpdateManager.isLoaded(updateType.getIdentifier());
    }

    public static void checkAndPull(String updateType, String identifier) {
        UpdateManager.get(updateType).ifPresent(type -> type.checkAndPut(identifier));
    }

    public static Optional<UpdateInfo> getLastUpdate(String updateType, String identifier) {
        return UpdateManager.get(updateType).map(type -> Singularity.getMainDatabase().checkUpdate((UpdateType<?>)type, identifier)).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get);
    }

    public static void update(String updateType, String identifier) {
        UpdateManager.get(updateType).ifPresent(type -> type.update(identifier));
    }

    public static ConcurrentSkipListSet<UpdateType<?>> getLoadedUpdateTypes() {
        return loadedUpdateTypes;
    }

    public static void setLoadedUpdateTypes(ConcurrentSkipListSet<UpdateType<?>> loadedUpdateTypes) {
        UpdateManager.loadedUpdateTypes = loadedUpdateTypes;
    }
}

